/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.annotations.Body;
import net.craftforge.essential.controller.annotations.Consumes;
import net.craftforge.essential.controller.annotations.DefaultValue;
import net.craftforge.essential.controller.annotations.Delete;
import net.craftforge.essential.controller.annotations.Get;
import net.craftforge.essential.controller.annotations.Head;
import net.craftforge.essential.controller.annotations.Header;
import net.craftforge.essential.controller.annotations.Param;
import net.craftforge.essential.controller.annotations.Path;
import net.craftforge.essential.controller.annotations.Post;
import net.craftforge.essential.controller.annotations.Produces;
import net.craftforge.essential.controller.annotations.Property;
import net.craftforge.essential.controller.annotations.Public;
import net.craftforge.essential.controller.annotations.Put;
import net.craftforge.essential.controller.annotations.Trace;
import net.craftforge.essential.controller.constants.HttpStatusCode;
import net.craftforge.essential.controller.utils.UriUtils;
import net.craftforge.essential.supply.Consumer;
import net.craftforge.essential.supply.Producer;
import net.craftforge.reflection.managers.ClassManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtils {
    public static String getPathFromClass(Class<?> clazz) {
        Path annotation = (Path)ClassManager.getInstance(clazz).getTypeLevelAnnotation(Path.class);
        return annotation == null ? null : UriUtils.standardUri(annotation.value());
    }

    public static String getPathFromMethod(Method method) {
        Path annotation = (Path)ClassManager.getInstance(method).getMethodLevelAnnotation(method, Path.class);
        return annotation == null ? null : UriUtils.standardUri(annotation.value());
    }

    public static String getParamFromProperty(Field field) {
        Param annotation = (Param)ClassManager.getInstance(field).getPropertyLevelAnnotation(field, Param.class);
        return annotation == null ? null : annotation.value();
    }

    public static String getHeaderFromProperty(Field field) {
        Header annotation = (Header)ClassManager.getInstance(field).getPropertyLevelAnnotation(field, Header.class);
        return annotation == null ? null : annotation.value();
    }

    public static String getPropertyFromProperty(Field field) {
        Property annotation = (Property)ClassManager.getInstance(field).getPropertyLevelAnnotation(field, Property.class);
        return annotation == null ? null : annotation.value();
    }

    public static boolean isBodyOnProperty(Field field) {
        Body annotation = (Body)ClassManager.getInstance(field).getPropertyLevelAnnotation(field, Body.class);
        return annotation != null;
    }

    public static String[] getDefaultValuesFromProperty(Field field) {
        DefaultValue annotation = (DefaultValue)ClassManager.getInstance(field).getPropertyLevelAnnotation(field, DefaultValue.class);
        return annotation == null ? null : annotation.value();
    }

    public static Method getProducerMethod(Object producer, String mediaTypes) throws ControllerException {
        Method method = AnnotationUtils.getBestMatchingMethod(producer, Produces.class, mediaTypes);
        if (!AnnotationUtils.isValidProducerMethod(method)) {
            throw new ControllerException("Producer method " + method.getName() + " has an invalid signature");
        }
        return method;
    }

    public static Method getConsumerMethod(Object consumer, String mediaTypes) throws ControllerException {
        Method method = AnnotationUtils.getBestMatchingMethod(consumer, Consumes.class, mediaTypes);
        if (!AnnotationUtils.isValidConsumerMethod(method)) {
            throw new ControllerException("Consumer method " + method.getName() + " has an invalid signature");
        }
        return method;
    }

    public static Method getBestMatchingMethod(Object supplier, Class<? extends Annotation> annotationType, String mediaTypes) throws ControllerException {
        int maxQuality = 0;
        Method bestMethod = null;
        for (Method method : supplier.getClass().getMethods()) {
            String[] value;
            if (!method.isAnnotationPresent(annotationType)) continue;
            Annotation annotation = method.getAnnotation(annotationType);
            if (annotationType.equals(Produces.class)) {
                Produces produces = (Produces)annotation;
                value = produces.value();
            } else if (annotationType.equals(Consumes.class)) {
                Consumes consumes = (Consumes)annotation;
                value = consumes.value();
            } else {
                throw new ControllerException("Unsupported annotation type: " + annotationType);
            }
            for (String produces : value) {
                int matchingQuality = AnnotationUtils.getMatchingQuality(produces, mediaTypes);
                if (matchingQuality <= maxQuality) continue;
                bestMethod = method;
                maxQuality = matchingQuality;
            }
        }
        if (bestMethod == null) {
            throw new ControllerException("Supplier class " + supplier.getClass() + " does not supply any of the " + "media types: " + mediaTypes, HttpStatusCode.UnsupportedMediaType);
        }
        return bestMethod;
    }

    public static String getBestMatchingMediaType(Object supplier, Class<? extends Annotation> annotationType, String mediaTypes) throws ControllerException {
        int maxQuality = 0;
        String bestMediaType = null;
        for (Method method : supplier.getClass().getMethods()) {
            String[] value;
            if (!method.isAnnotationPresent(annotationType)) continue;
            Annotation annotation = method.getAnnotation(annotationType);
            if (annotationType.equals(Produces.class)) {
                Produces produces = (Produces)annotation;
                value = produces.value();
            } else if (annotationType.equals(Consumes.class)) {
                Consumes consumes = (Consumes)annotation;
                value = consumes.value();
            } else {
                throw new ControllerException("Unsupported annotation type: " + annotationType);
            }
            for (String produces : value) {
                int matchingQuality = AnnotationUtils.getMatchingQuality(produces, mediaTypes);
                if (matchingQuality <= maxQuality) continue;
                bestMediaType = produces;
                maxQuality = matchingQuality;
            }
        }
        if (bestMediaType == null) {
            throw new ControllerException("Supplier class " + supplier.getClass() + " does not supply any of the " + "media types: " + mediaTypes, HttpStatusCode.UnsupportedMediaType);
        }
        return bestMediaType;
    }

    private static int getMatchingQuality(String availableEnum, String acceptedEnum) throws ControllerException {
        int maxQuality = 0;
        for (String acceptedType : acceptedEnum.split(",")) {
            acceptedType = acceptedType.split(";")[0];
            String[] acceptedParts = (acceptedType = acceptedType.trim()).split("/");
            if (acceptedParts.length == 1) {
                acceptedParts = new String[]{acceptedParts[0], "*"};
            }
            for (String availableType : availableEnum.split(",")) {
                String[] availableParts = (availableType = availableType.trim()).split("/");
                if (availableParts.length == 1) {
                    availableParts = new String[]{availableParts[0], "*"};
                }
                int currentQuality = 0;
                if (availableParts[0].equals("*") && availableParts[1].equals("*")) {
                    currentQuality = acceptedParts[0].equals("*") && acceptedParts[1].equals("*") ? 3 : (acceptedParts[1].equals("*") ? 2 : 1);
                } else if (availableParts[0].equals(acceptedParts[0]) && availableParts[1].equals("*")) {
                    currentQuality = acceptedParts[1].equals("*") ? 5 : 4;
                } else if (availableParts[0].equals(acceptedParts[0]) && availableParts[1].equals(acceptedParts[1])) {
                    currentQuality = 6;
                }
                maxQuality = Math.max(currentQuality, maxQuality);
            }
        }
        return maxQuality;
    }

    public static Class<?> getProducerFromMethodOrClass(Method method) {
        net.craftforge.essential.controller.annotations.Producer annotation = (net.craftforge.essential.controller.annotations.Producer)ClassManager.getInstance(method).getMethodOrTypeLevelAnnotation(method, net.craftforge.essential.controller.annotations.Producer.class);
        return annotation == null ? null : annotation.value();
    }

    public static Class<?> getConsumerFromMethodOrClass(Method method) {
        net.craftforge.essential.controller.annotations.Consumer annotation = (net.craftforge.essential.controller.annotations.Consumer)ClassManager.getInstance(method).getMethodOrTypeLevelAnnotation(method, net.craftforge.essential.controller.annotations.Consumer.class);
        return annotation == null ? null : annotation.value();
    }

    public static boolean isPublic(Method method) {
        Public annotation = (Public)ClassManager.getInstance(method).getMethodOrTypeLevelAnnotation(method, Public.class);
        return annotation != null;
    }

    public static List<Field> getParamFieldsFromClass(Class<?> clazz) {
        return ClassManager.getInstance(clazz).getAllPropertiesAnnotatedWith(Param.class);
    }

    public static List<Field> getHeaderFieldsFromClass(Class<?> clazz) {
        return ClassManager.getInstance(clazz).getAllPropertiesAnnotatedWith(Header.class);
    }

    public static List<Field> getBodyFieldsFromClass(Class<?> clazz) {
        return ClassManager.getInstance(clazz).getAllPropertiesAnnotatedWith(Body.class);
    }

    public static List<Field> getPropertyFieldsFromClass(Class<?> clazz) {
        return ClassManager.getInstance(clazz).getAllPropertiesAnnotatedWith(Property.class);
    }

    public static List<Field> getAnnotatedFieldsFromClass(Class<?> clazz) {
        LinkedList<Field> annotatedFields = new LinkedList<Field>();
        annotatedFields.addAll(AnnotationUtils.getParamFieldsFromClass(clazz));
        annotatedFields.addAll(AnnotationUtils.getBodyFieldsFromClass(clazz));
        annotatedFields.addAll(AnnotationUtils.getHeaderFieldsFromClass(clazz));
        annotatedFields.addAll(AnnotationUtils.getPropertyFieldsFromClass(clazz));
        return annotatedFields;
    }

    public static List<Method> getResourceMethodsFromClass(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        methods.addAll(ClassManager.getInstance(clazz).getAllMethodsAnnotatedWith(Get.class));
        methods.addAll(ClassManager.getInstance(clazz).getAllMethodsAnnotatedWith(Post.class));
        methods.addAll(ClassManager.getInstance(clazz).getAllMethodsAnnotatedWith(Put.class));
        methods.addAll(ClassManager.getInstance(clazz).getAllMethodsAnnotatedWith(Delete.class));
        methods.addAll(ClassManager.getInstance(clazz).getAllMethodsAnnotatedWith(Head.class));
        methods.addAll(ClassManager.getInstance(clazz).getAllMethodsAnnotatedWith(Trace.class));
        return methods;
    }

    public static List<String> getSupportedProducerMediaTypes(Class<?> clazz) {
        HashSet<String> mediaTypes = new HashSet<String>();
        List<Method> methods = ClassManager.getInstance(clazz).getAllMethodsAnnotatedWith(Produces.class);
        for (Method method : methods) {
            Produces ann = (Produces)ClassManager.getInstance(method).getMethodLevelAnnotation(method, Produces.class);
            mediaTypes.addAll(Arrays.asList(ann.value()));
        }
        return new ArrayList<String>(mediaTypes);
    }

    public static List<String> getSupportedConsumerMediaTypes(Class<?> clazz) {
        HashSet<String> mediaTypes = new HashSet<String>();
        List<Method> methods = ClassManager.getInstance(clazz).getAllMethodsAnnotatedWith(Consumes.class);
        for (Method method : methods) {
            Consumes ann = (Consumes)ClassManager.getInstance(method).getMethodLevelAnnotation(method, Consumes.class);
            mediaTypes.addAll(Arrays.asList(ann.value()));
        }
        return new ArrayList<String>(mediaTypes);
    }

    public static Class[][] getValidConsumerParameterTypes() {
        return new Class[][]{{Class.class, String.class}, {Class.class, InputStream.class, String.class}};
    }

    public static Class[][] getValidProducerParameterTypes() {
        return new Class[][]{{Object.class, OutputStream.class, String.class}};
    }

    public static boolean isValidProducerMethod(Method method) {
        return AnnotationUtils.isValidMethod(method, AnnotationUtils.getValidProducerParameterTypes());
    }

    public static boolean isValidConsumerMethod(Method method) {
        return AnnotationUtils.isValidMethod(method, AnnotationUtils.getValidConsumerParameterTypes());
    }

    public static boolean isValidMethod(Method method, Class[][] validParameterTypes) {
        Object[] actualParameterTypes = method.getParameterTypes();
        for (Object[] objectArray : validParameterTypes) {
            if (!Arrays.equals(actualParameterTypes, objectArray)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStreamingSupported(Consumer consumer, String mediaType) throws ControllerException {
        Method method = AnnotationUtils.getConsumerMethod(consumer, mediaType);
        return method.getParameterTypes()[1].equals(InputStream.class);
    }

    public static boolean isStreamingSupported(Producer producer, String mediaType) throws ControllerException {
        Method method = AnnotationUtils.getProducerMethod(producer, mediaType);
        return method.getParameterTypes()[1].equals(OutputStream.class);
    }

    public static String getHttpMethod(Method method) {
        Annotation annotation = ClassManager.getInstance(method).getMethodLevelAnnotation(method, Get.class);
        if (annotation != null) {
            return "GET";
        }
        annotation = ClassManager.getInstance(method).getMethodLevelAnnotation(method, Post.class);
        if (annotation != null) {
            return "POST";
        }
        annotation = ClassManager.getInstance(method).getMethodLevelAnnotation(method, Put.class);
        if (annotation != null) {
            return "PUT";
        }
        annotation = ClassManager.getInstance(method).getMethodLevelAnnotation(method, Delete.class);
        if (annotation != null) {
            return "DELETE";
        }
        annotation = ClassManager.getInstance(method).getMethodLevelAnnotation(method, Head.class);
        if (annotation != null) {
            return "HEAD";
        }
        annotation = ClassManager.getInstance(method).getMethodLevelAnnotation(method, Trace.class);
        if (annotation != null) {
            return "TRACE";
        }
        return null;
    }
}

