/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.phases.flow;

import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.Phase;
import net.craftforge.essential.controller.Setup;
import net.craftforge.essential.controller.State;
import net.craftforge.essential.controller.phases.AllocationPhase;
import net.craftforge.essential.controller.phases.AuthenticationPhase;
import net.craftforge.essential.controller.phases.DocumentationPhase;
import net.craftforge.essential.controller.phases.InvocationPhase;
import net.craftforge.essential.controller.phases.ProductionPhase;
import net.craftforge.essential.controller.phases.flow.PhaseFlow;
import net.craftforge.essential.controller.utils.AnnotationUtils;

public class StandardPhaseFlow
implements PhaseFlow {
    private State state;
    private Setup setup;

    public void setState(State state) {
        this.state = state;
    }

    public void setSetup(Setup setup) {
        this.setup = setup;
    }

    public Phase getFirstPhase() {
        if (this.setup.getHttpMethod().equalsIgnoreCase("OPTIONS")) {
            return new DocumentationPhase(this.state, this.setup);
        }
        return new AllocationPhase(this.state, this.setup);
    }

    public Phase getPhaseAfter(Phase phase) throws ControllerException {
        if (phase instanceof AllocationPhase) {
            return this.getPhaseAfterAllocation();
        }
        if (phase instanceof AuthenticationPhase) {
            return this.getPhaseAfterAuthentication();
        }
        if (phase instanceof InvocationPhase) {
            return this.getPhaseAfterInvocation();
        }
        if (phase instanceof DocumentationPhase) {
            return this.getPhaseAfterDocumentation();
        }
        if (phase instanceof ProductionPhase) {
            return this.getPhaseAfterProduction();
        }
        throw new ControllerException("Undefined flow for phase: " + phase.getClass());
    }

    protected Phase getPhaseAfterAllocation() {
        if (this.setup.getConfiguration().getAuthenticationHandler() == null || AnnotationUtils.isPublic(this.state.getResourceMethod())) {
            return this.getPhaseAfterAuthentication();
        }
        return new AuthenticationPhase(this.state, this.setup);
    }

    protected Phase getPhaseAfterAuthentication() {
        return new InvocationPhase(this.state, this.setup);
    }

    protected Phase getPhaseAfterInvocation() {
        return new ProductionPhase(this.state, this.setup);
    }

    protected Phase getPhaseAfterDocumentation() {
        return new ProductionPhase(this.state, this.setup);
    }

    protected Phase getPhaseAfterProduction() {
        return null;
    }
}

