/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.phases;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.Phase;
import net.craftforge.essential.controller.Setup;
import net.craftforge.essential.controller.State;
import net.craftforge.essential.controller.utils.AnnotationUtils;
import net.craftforge.essential.supply.Producer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionPhase
implements Phase {
    private State state;
    private Setup setup;

    public ProductionPhase(State state, Setup setup) {
        this.state = state;
        this.setup = setup;
    }

    @Override
    public void run() throws ControllerException {
        try {
            if (this.state.getResult() == null) {
                this.setup.getResponse().sendHeaders(this.state.getStatus(), this.getHeadersWithoutContent());
            } else {
                Producer producer = this.getProducer();
                this.setup.getResponse().sendHeaders(this.state.getStatus(), this.getHeadersWithContent(producer));
                producer.produce(this.setup.getAcceptedMediaType(), this.state.getResult(), this.setup.getResponseBodyOutputStream(), this.setup.getAcceptedCharset());
            }
        }
        catch (RuntimeException e) {
            throw new ControllerException("An unexpected exception occurred during production", e);
        }
    }

    protected Map<String, String[]> getHeadersWithoutContent() throws ControllerException {
        return new HashMap<String, String[]>();
    }

    protected Map<String, String[]> getHeadersWithContent(Producer producer) throws ControllerException {
        Map<String, String[]> headers = this.getHeadersWithoutContent();
        String mediaType = producer.getBestMatchingMediaType(this.setup.getAcceptedMediaType());
        String charset = this.setup.getAcceptedCharset();
        headers.put("Content-Type", new String[]{mediaType + "; charset=" + charset});
        return headers;
    }

    protected Producer getProducer() throws ControllerException {
        Producer producer;
        Class<?> producerClass = null;
        if (!this.setup.getHttpMethod().equals("OPTIONS")) {
            producerClass = AnnotationUtils.getProducerFromMethodOrClass(this.state.getResourceMethod());
        }
        if (producerClass == null) {
            producerClass = this.setup.getConfiguration().getDefaultProducer();
        }
        try {
            try {
                producer = (Producer)producerClass.getConstructor(Configuration.class).newInstance(this.setup.getConfiguration());
            }
            catch (NoSuchMethodException e) {
                producer = (Producer)producerClass.newInstance();
            }
        }
        catch (InstantiationException e) {
            throw new ControllerException("The producer class specified in the controller configuration or annotated at the resource method could not be instantiated: " + producerClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ControllerException("The producer class specified in the controller configuration or annotated at the resource method could not be instantiated: " + producerClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ControllerException("The producer class specified in the controller configuration or annotated at the resource method could not be instantiated: " + producerClass.getName(), e);
        }
        return producer;
    }
}

