/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.phases;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;
import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.Phase;
import net.craftforge.essential.controller.Setup;
import net.craftforge.essential.controller.State;
import net.craftforge.essential.controller.constants.HttpStatusCode;
import net.craftforge.essential.controller.managers.InjectionManager;
import net.craftforge.essential.controller.utils.AnnotationUtils;
import net.craftforge.essential.supply.Consumer;
import net.craftforge.reflection.utils.PropertyUtils;
import net.craftforge.reflection.utils.ReflUtils;

public class InvocationPhase
implements Phase {
    private State state;
    private Setup setup;

    public InvocationPhase(State state, Setup setup) {
        this.state = state;
        this.setup = setup;
    }

    public void run() throws ControllerException {
        try {
            Object resource;
            Consumer consumer;
            Class<?> consumerClass = AnnotationUtils.getConsumerFromMethodOrClass(this.state.getResourceMethod());
            if (consumerClass == null) {
                consumerClass = this.setup.getConfiguration().getDefaultConsumer();
            }
            try {
                try {
                    consumer = (Consumer)consumerClass.getConstructor(Configuration.class).newInstance(this.setup.getConfiguration());
                }
                catch (NoSuchMethodException e) {
                    consumer = (Consumer)consumerClass.newInstance();
                }
            }
            catch (InstantiationException e) {
                throw new ControllerException("The consumer class specified in the controller configuration or annotated at the resource method could not be instantiated: " + consumerClass.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new ControllerException("The consumer class specified in the controller configuration or annotated at the resource method could not be instantiated: " + consumerClass.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new ControllerException("The consumer class specified in the controller configuration or annotated at the resource method could not be instantiated: " + consumerClass.getName(), e);
            }
            InjectionManager injectionManager = new InjectionManager(consumer, this.setup.getBodyHandler(), this.setup.getHeaderHandler(), this.setup.getParameterHandler(), this.setup.getPropertyHandler());
            try {
                resource = this.state.getResourceClass().newInstance();
            }
            catch (InstantiationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ControllerException) {
                    throw (ControllerException)cause;
                }
                throw new ControllerException("The allocated resource class could not be instantiated: " + this.state.getResourceClass(), cause);
            }
            catch (IllegalAccessException e) {
                throw new ControllerException("The allocated resource class could not be instantiated: " + this.state.getResourceClass(), e);
            }
            for (Field field : AnnotationUtils.getAnnotatedFieldsFromClass(resource.getClass())) {
                try {
                    PropertyUtils.setProperty(resource, field, injectionManager.getInputForField(field));
                }
                catch (NoSuchMethodException e) {
                    throw new ControllerException("A property of the resource class could not be set via the setter method: " + ReflUtils.setterName(field.getName()) + "()" + " in resource class " + this.state.getResourceClass().getName(), e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ControllerException) {
                        throw (ControllerException)cause;
                    }
                    throw new ControllerException("A property of the resource class could not be set via the setter method: " + ReflUtils.setterName(field.getName()) + "()" + " in resource class " + this.state.getResourceClass(), cause);
                }
                catch (IllegalAccessException e) {
                    throw new ControllerException("A property of the resource class could not be set: " + field.getName() + " in resource class " + this.state.getResourceClass(), e);
                }
            }
            List<Object> parameterValues = injectionManager.getInputForMethodParameters(this.state.getResourceMethod());
            Object result = null;
            this.state.setInvocationStart(new Date());
            try {
                if (!this.state.getResourceMethod().getReturnType().equals(Void.TYPE)) {
                    result = parameterValues.size() == 0 ? this.state.getResourceMethod().invoke(resource, new Object[0]) : this.state.getResourceMethod().invoke(resource, parameterValues.toArray());
                    this.state.setStatus(HttpStatusCode.OK);
                } else {
                    if (parameterValues.size() == 0) {
                        this.state.getResourceMethod().invoke(resource, new Object[0]);
                    } else {
                        this.state.getResourceMethod().invoke(resource, parameterValues.toArray());
                    }
                    this.state.setStatus(HttpStatusCode.NoContent);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ControllerException) {
                    throw (ControllerException)cause;
                }
                throw new ControllerException("The resource method failed during execution: " + this.state.getResourceMethod(), cause);
            }
            catch (IllegalAccessException e) {
                throw new ControllerException("The resource method could not be invoked: " + this.state.getResourceMethod(), e);
            }
            this.state.setInvocationEnd(new Date());
            this.state.setResult(result);
        }
        catch (RuntimeException e) {
            throw new ControllerException("An unexpected exception occurred during resource method invocation", e);
        }
    }
}

