/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.phases;

import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.Phase;
import net.craftforge.essential.controller.Setup;
import net.craftforge.essential.controller.State;
import net.craftforge.essential.controller.constants.HttpStatusCode;
import net.craftforge.essential.controller.handlers.AuthenticationHandler;

public class AuthenticationPhase
implements Phase {
    private State state;
    private Setup setup;

    public AuthenticationPhase(State state, Setup setup) {
        this.state = state;
        this.setup = setup;
    }

    public void run() throws ControllerException {
        try {
            AuthenticationHandler handler;
            Class<?> handlerClass = this.setup.getConfiguration().getAuthenticationHandler();
            if (handlerClass == null) {
                return;
            }
            try {
                handler = (AuthenticationHandler)handlerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ControllerException("The authentication handler class specified in the controller configuration could not be instantiated: " + handlerClass.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new ControllerException("The authentication handler class specified in the controller configuration could not be instantiated: " + handlerClass.getName(), e);
            }
            String user = this.setup.getHeaderHandler().getAuthorizationUser();
            String pass = this.setup.getHeaderHandler().getAuthorizationPassword();
            if (user == null || pass == null) {
                throw new ControllerException("Authentication failed because no user and/or password  was transmitted in the authorization header", HttpStatusCode.Unauthorized);
            }
            if (!handler.authenticate(this.setup)) {
                throw new ControllerException("Authentication failed because the user does not exist or user and password do not match", HttpStatusCode.Unauthorized);
            }
        }
        catch (RuntimeException e) {
            throw new ControllerException("An unexpected exception occurred during authentication", e);
        }
    }
}

