/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.phases;

import java.lang.reflect.Method;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.Phase;
import net.craftforge.essential.controller.Setup;
import net.craftforge.essential.controller.State;
import net.craftforge.essential.controller.constants.HttpStatusCode;
import net.craftforge.essential.controller.managers.ResourceManager;

public class AllocationPhase
implements Phase {
    private State state;
    private Setup setup;

    public AllocationPhase(State state, Setup setup) {
        this.state = state;
        this.setup = setup;
    }

    public void run() throws ControllerException {
        try {
            if (this.state.getResourceMethod() == null) {
                String httpMethod = this.setup.getHttpMethod();
                String resourcePath = this.setup.getRequestUrlResourcePart();
                ResourceManager resourceManager = this.setup.getResourceManager();
                Class<?> resourceClass = resourceManager.getResourceClass(resourcePath);
                if (resourceClass == null) {
                    throw new ControllerException("'" + httpMethod + " " + resourcePath + "' has no responsible resource class", HttpStatusCode.NotFound);
                }
                Method resourceMethod = resourceManager.getResourceMethod(httpMethod, resourcePath, resourceClass);
                if (resourceMethod == null) {
                    throw new ControllerException("'" + httpMethod + " " + resourcePath + "' has no responsible resource method", HttpStatusCode.NotFound);
                }
                this.state.setResourceClass(resourceClass);
                this.state.setResourceMethod(resourceMethod);
            }
        }
        catch (RuntimeException e) {
            throw new ControllerException("An unexpected exception occurred during resource allocation", e);
        }
    }
}

