/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.managers;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.craftforge.essential.controller.allocation.ResourceNode;
import net.craftforge.essential.controller.allocation.ResourceTree;
import net.craftforge.essential.controller.utils.AnnotationUtils;
import net.craftforge.essential.controller.utils.RegExUtils;
import net.craftforge.essential.controller.utils.UriUtils;
import net.craftforge.reflection.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceManager.class);
    private static ConcurrentMap<String, ResourceManager> instances = new ConcurrentHashMap<String, ResourceManager>();
    private ResourceTree resourceTree;

    public static ResourceManager getInstance(String packagePath) {
        if (!instances.containsKey(packagePath)) {
            LOGGER.info("[Resource manager initialization] {}", (Object)packagePath);
            instances.putIfAbsent(packagePath, new ResourceManager(packagePath));
        }
        return (ResourceManager)instances.get(packagePath);
    }

    private ResourceManager(String packagePath) {
        this.resourceTree = ResourceTree.getInstance(packagePath);
    }

    public Map<String, String[]> getPathParameters(String requestPath) {
        String[] requestPathParts = UriUtils.splitPath(requestPath);
        HashMap<String, String[]> pathParameterMap = new HashMap<String, String[]>(requestPathParts.length);
        List<ResourceNode> resourceNodes = this.resourceTree.findResourceNodesAlongPath(requestPath);
        for (ResourceNode resourceNode : resourceNodes) {
            String pathPart = resourceNode.getPathPart();
            if (!RegExUtils.FIND_ENCLOSED_BY_CURLY_BRACKETS.matcher(pathPart).matches()) continue;
            String requestPathPart = requestPathParts[resourceNode.getLevel()];
            String key = RegExUtils.getParamNameFromPathPart(resourceNode.getPathPart());
            String[] values = RegExUtils.getValuesFromPathPart(requestPathPart);
            pathParameterMap.put(key, values);
        }
        return pathParameterMap;
    }

    public Class<?> getResourceClass(String path) {
        ResourceNode resourceNode = this.resourceTree.findResourceNode(path);
        return resourceNode == null ? null : resourceNode.getResourceClass();
    }

    public Method getResourceMethod(String httpMethod, String path, Class<?> resourceClass) {
        ResourceNode resourceNode = this.resourceTree.findResourceNode(path);
        if (resourceNode == null) {
            return null;
        }
        for (Method resourceMethod : resourceNode.getResourceMethods()) {
            if (!httpMethod.equalsIgnoreCase(AnnotationUtils.getHttpMethod(resourceMethod))) continue;
            return ClassUtils.getFirstImplementation(resourceClass, resourceMethod);
        }
        return null;
    }
}

