/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.managers;

import java.util.Collections;
import java.util.Map;
import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.ControllerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyHandler {
    private Configuration configuration;

    public PropertyHandler(Configuration configuration) {
        this.configuration = configuration;
    }

    public Map<String, String> getProperties(String propertyName, String[] defaultValues) throws ControllerException {
        Map<String, String> result = this.configuration.getProperties(propertyName);
        if (result == null || result.isEmpty()) {
            if (defaultValues == null) {
                throw new ControllerException("At least one configuration property with prefix " + propertyName + " is " + "expected to be passed in the configuration but is missing");
            }
            result = Collections.emptyMap();
        }
        return result;
    }

    public String getProperty(String propertyName, String[] defaultValues) throws ControllerException {
        String result = this.configuration.getProperty(propertyName);
        if (result == null) {
            if (defaultValues == null || defaultValues.length < 1) {
                throw new ControllerException("The configuration property " + propertyName + " is " + "expected to be passed in the configuration but is missing");
            }
            result = defaultValues[0];
        }
        return result;
    }
}

