/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.managers;

import java.util.Collection;
import java.util.Map;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.constants.HttpStatusCode;
import net.craftforge.essential.supply.Consumer;
import net.craftforge.reflection.utils.ReflUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterHandler {
    private Map<String, String[]> parameters;

    public ParameterHandler(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public String[] getParameterValues(String parameterName, String[] defaultValues) throws ControllerException {
        String[] parameterValues = this.parameters.get(parameterName);
        if (parameterValues != null) {
            return parameterValues;
        }
        if (defaultValues != null) {
            return defaultValues;
        }
        throw this.getMissingParameterException(parameterName);
    }

    public String getParameterValue(String parameterName, String[] defaultValues) throws ControllerException {
        String[] parameterValues = this.parameters.get(parameterName);
        if (parameterValues != null && parameterValues.length > 0) {
            return parameterValues[0];
        }
        if (defaultValues != null && defaultValues.length > 0) {
            return defaultValues[0];
        }
        throw this.getMissingParameterException(parameterName);
    }

    public Object getParameterValueAsObject(Consumer consumer, Class<?> type, String parameterName, String[] defaultValues) throws ControllerException {
        String parameterValue = this.getParameterValue(parameterName, defaultValues);
        return this.convertToObject(consumer, type, parameterValue);
    }

    public <G> Collection<G> getParameterValuesAsObject(Consumer consumer, Class<?> collectionType, Class<G> typeArgument, String parameterName, String[] defaultValues) throws ControllerException {
        Collection collection = ReflUtils.createCollection(collectionType);
        for (String paramValue : this.getParameterValues(parameterName, defaultValues)) {
            collection.add(this.convertToObject(consumer, typeArgument, paramValue));
        }
        return collection;
    }

    protected Object convertToObject(Consumer consumer, Class<?> type, String parameterValue) throws ControllerException {
        if (!ReflUtils.isVirtualPrimitive(type)) {
            throw new ControllerException("Failed to consume a parameter value because the target type is not a virtual primitive like int, Long or String", HttpStatusCode.BadRequest);
        }
        return consumer.consume(type, "text/plain", parameterValue);
    }

    protected ControllerException getMissingParameterException(String paramName) {
        return new ControllerException("The parameter " + paramName + " is " + "expected to be passed in the request but is missing", HttpStatusCode.BadRequest);
    }
}

