/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.managers;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.annotations.Body;
import net.craftforge.essential.controller.annotations.DefaultValue;
import net.craftforge.essential.controller.annotations.Header;
import net.craftforge.essential.controller.annotations.Param;
import net.craftforge.essential.controller.annotations.Property;
import net.craftforge.essential.controller.managers.BodyHandler;
import net.craftforge.essential.controller.managers.HeaderHandler;
import net.craftforge.essential.controller.managers.ParameterHandler;
import net.craftforge.essential.controller.managers.PropertyHandler;
import net.craftforge.essential.controller.utils.AnnotationUtils;
import net.craftforge.essential.supply.Consumer;
import net.craftforge.reflection.managers.ClassManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionManager {
    private Consumer consumer;
    private ParameterHandler parameterHandler;
    private HeaderHandler headerHandler;
    private BodyHandler bodyHandler;
    private PropertyHandler propertyHandler;

    public InjectionManager(Consumer consumer, BodyHandler bodyHandler, HeaderHandler headerHandler, ParameterHandler parameterHandler, PropertyHandler propertyHandler) {
        this.consumer = consumer;
        this.parameterHandler = parameterHandler;
        this.headerHandler = headerHandler;
        this.bodyHandler = bodyHandler;
        this.propertyHandler = propertyHandler;
    }

    public Object getInputForField(Field field) throws ControllerException {
        Class<?> type = field.getType();
        if (AnnotationUtils.isBodyOnProperty(field)) {
            return this.getBodyInput(this.consumer, type);
        }
        String[] defaultValues = AnnotationUtils.getDefaultValuesFromProperty(field);
        String headerName = AnnotationUtils.getHeaderFromProperty(field);
        if (headerName != null) {
            return this.getHeaderInput(type, headerName, defaultValues);
        }
        String paramName = AnnotationUtils.getParamFromProperty(field);
        if (paramName != null) {
            paramName = paramName.isEmpty() ? field.getName() : paramName;
            Type genericType = field.getGenericType();
            return this.getParameterInput(this.consumer, type, genericType, paramName, defaultValues);
        }
        String propertyName = AnnotationUtils.getPropertyFromProperty(field);
        if (propertyName != null) {
            return this.getPropertyInput(type, propertyName, defaultValues);
        }
        return null;
    }

    public List<Object> getInputForMethodParameters(Method method) throws ControllerException {
        int paramIterator = 0;
        Class<?>[] paramTypes = method.getParameterTypes();
        Type[] paramGenericTypes = method.getGenericParameterTypes();
        ArrayList<Object> parameterInputs = new ArrayList<Object>(method.getParameterTypes().length);
        Annotation[][] usedAnnotations = ClassManager.getInstance(method).getMethodParameterAnnotations(method, Body.class);
        if (usedAnnotations == null || usedAnnotations.length < 1) {
            usedAnnotations = ClassManager.getInstance(method).getMethodParameterAnnotations(method, Header.class);
        }
        if (usedAnnotations == null || usedAnnotations.length < 1) {
            usedAnnotations = ClassManager.getInstance(method).getMethodParameterAnnotations(method, Param.class);
        }
        if (usedAnnotations == null || usedAnnotations.length < 1) {
            usedAnnotations = ClassManager.getInstance(method).getMethodParameterAnnotations(method, Property.class);
        }
        if (usedAnnotations == null || usedAnnotations.length < 1) {
            return Collections.emptyList();
        }
        for (Annotation[] annotations : usedAnnotations) {
            Class<?> type = paramTypes[paramIterator];
            Type genericType = paramGenericTypes[paramIterator];
            String[] defaultValues = null;
            for (Annotation ann : annotations) {
                if (!ann.annotationType().equals(DefaultValue.class)) continue;
                defaultValues = ((DefaultValue)ann).value();
                break;
            }
            for (Annotation ann : annotations) {
                Object input;
                if (ann.annotationType().equals(Body.class)) {
                    Object input2 = this.getBodyInput(this.consumer, type);
                    parameterInputs.add(input2);
                    break;
                }
                if (ann.annotationType().equals(Header.class)) {
                    String headerName = ((Header)ann).value();
                    input = this.getHeaderInput(type, headerName, defaultValues);
                    parameterInputs.add(input);
                    break;
                }
                if (ann.annotationType().equals(Param.class)) {
                    String paramName = ((Param)ann).value();
                    input = this.getParameterInput(this.consumer, type, genericType, paramName, defaultValues);
                    parameterInputs.add(input);
                    break;
                }
                if (!ann.annotationType().equals(Property.class)) continue;
                String propertyName = ((Property)ann).value();
                input = this.getPropertyInput(type, propertyName, defaultValues);
                parameterInputs.add(input);
                break;
            }
            ++paramIterator;
        }
        return parameterInputs;
    }

    public Object getBodyInput(Consumer consumer, Class<?> type) throws ControllerException {
        String mediaType = this.headerHandler.getContentMediaType("text/xml");
        String charset = this.headerHandler.getContentCharset("UTF-8");
        if (type.isAssignableFrom(InputStream.class)) {
            return this.bodyHandler.getBodyInputStream();
        }
        if (type.isAssignableFrom(String.class)) {
            return this.bodyHandler.getBodyContent(charset);
        }
        return this.bodyHandler.getBodyObject(consumer, type, mediaType, charset);
    }

    public Object getHeaderInput(Class<?> type, String headerName, String[] defaultValues) throws ControllerException {
        if (type.isAssignableFrom(String[].class)) {
            return this.headerHandler.getHeaderValues(headerName, defaultValues);
        }
        return this.headerHandler.getHeaderValue(headerName, defaultValues);
    }

    public Object getParameterInput(Consumer consumer, Class<?> type, Type genericType, String parameterName, String[] defaultValues) throws ControllerException {
        if (type.isAssignableFrom(String[].class)) {
            return this.parameterHandler.getParameterValues(parameterName, defaultValues);
        }
        if (type.isAssignableFrom(String.class)) {
            return this.parameterHandler.getParameterValue(parameterName, defaultValues);
        }
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            Class typeArgument = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
            return this.parameterHandler.getParameterValuesAsObject(consumer, type, typeArgument, parameterName, defaultValues);
        }
        return this.parameterHandler.getParameterValueAsObject(consumer, type, parameterName, defaultValues);
    }

    public Object getPropertyInput(Class<?> type, String propertyName, String[] defaultValues) throws ControllerException {
        if (Map.class.isAssignableFrom(type)) {
            return this.propertyHandler.getProperties(propertyName, defaultValues);
        }
        if (type.isAssignableFrom(String.class)) {
            return this.propertyHandler.getProperty(propertyName, defaultValues);
        }
        throw new ControllerException("The configuration property " + propertyName + " cannot " + "be initialized because its type is neither applicable to String nor to Map");
    }
}

