/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.managers;

import java.util.Map;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.constants.HttpStatusCode;
import net.craftforge.essential.controller.utils.HeaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderHandler {
    private Map<String, String[]> headers;
    private String authorizationUser;
    private String authorizationPassword;
    private String contentMediaType;
    private String contentCharset;

    public HeaderHandler(Map<String, String[]> headers) {
        this.headers = headers;
        this.initAuthorization();
        this.initContentType();
    }

    protected void initAuthorization() {
        String[] authorizationHeaders = this.headers.get("Authorization");
        if (authorizationHeaders == null || authorizationHeaders.length < 1) {
            return;
        }
        String[] authPair = HeaderUtils.getAuthorizationPair(authorizationHeaders);
        this.authorizationUser = authPair[0];
        this.authorizationPassword = authPair[1];
    }

    protected void initContentType() {
        String[] contentTypeHeaders = this.headers.get("Content-Type");
        if (contentTypeHeaders == null || contentTypeHeaders.length < 1) {
            return;
        }
        String[] contentTypePair = HeaderUtils.getContentTypePair(contentTypeHeaders[0]);
        this.contentMediaType = contentTypePair[0];
        this.contentCharset = contentTypePair[1];
    }

    public String[] getHeaderValues(String headerName, String[] defaultValues) throws ControllerException {
        String[] headerValues = this.headers.get(headerName);
        if (headerValues != null) {
            return headerValues;
        }
        if (defaultValues != null) {
            return defaultValues;
        }
        throw this.getMissingHeaderException(headerName);
    }

    public String getHeaderValue(String headerName, String defaultValue) throws ControllerException {
        if (headerName.equals("Authorization#user")) {
            return this.getAuthorizationUser();
        }
        if (headerName.equalsIgnoreCase("Authorization#pass")) {
            return this.getAuthorizationPassword();
        }
        if (headerName.equalsIgnoreCase("Content-Type#media")) {
            return this.getContentMediaType(defaultValue);
        }
        if (headerName.equalsIgnoreCase("Content-Type#charset")) {
            return this.getContentCharset(defaultValue);
        }
        String[] headerValues = this.headers.get(headerName);
        if (headerValues != null && headerValues.length > 0) {
            return headerValues[0];
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw this.getMissingHeaderException(headerName);
    }

    public String getHeaderValue(String headerName, String[] defaultValues) throws ControllerException {
        String[] headerValues = this.headers.get(headerName);
        if (headerValues != null && headerValues.length > 0) {
            return headerValues[0];
        }
        if (defaultValues != null && defaultValues.length > 0) {
            return defaultValues[0];
        }
        throw this.getMissingHeaderException(headerName);
    }

    public String getAuthorizationUser() {
        return this.authorizationUser;
    }

    public String getAuthorizationPassword() {
        return this.authorizationPassword;
    }

    public String getContentMediaType(String defaultValue) {
        return this.contentMediaType == null ? defaultValue : this.contentMediaType;
    }

    public String getContentCharset(String defaultValue) {
        return this.contentCharset == null ? defaultValue : this.contentCharset;
    }

    protected ControllerException getMissingHeaderException(String headerName) {
        return new ControllerException("The header " + headerName + " is " + "expected to be part of the request but is missing", HttpStatusCode.BadRequest);
    }
}

