/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.managers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.allocation.ResourceNode;
import net.craftforge.essential.controller.allocation.ResourceTree;
import net.craftforge.essential.controller.annotations.DefaultValue;
import net.craftforge.essential.controller.annotations.Param;
import net.craftforge.essential.controller.constants.HttpStatusCode;
import net.craftforge.essential.controller.documentation.jaxb.WadlApplication;
import net.craftforge.essential.controller.documentation.jaxb.WadlMethod;
import net.craftforge.essential.controller.documentation.jaxb.WadlParam;
import net.craftforge.essential.controller.documentation.jaxb.WadlParamStyle;
import net.craftforge.essential.controller.documentation.jaxb.WadlRepresentation;
import net.craftforge.essential.controller.documentation.jaxb.WadlRequest;
import net.craftforge.essential.controller.documentation.jaxb.WadlResource;
import net.craftforge.essential.controller.documentation.jaxb.WadlResponse;
import net.craftforge.essential.controller.utils.AnnotationUtils;
import net.craftforge.essential.controller.utils.RegExUtils;
import net.craftforge.reflection.managers.ClassManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentationManager.class);
    private static ConcurrentMap<String, DocumentationManager> instances = new ConcurrentHashMap<String, DocumentationManager>();
    private ResourceTree resourceTree;

    public static DocumentationManager getInstance(String packageName) {
        if (!instances.containsKey(packageName)) {
            LOGGER.info("[Documentation manager initialization] {}", (Object)packageName);
            instances.putIfAbsent(packageName, new DocumentationManager(packageName));
        }
        return (DocumentationManager)instances.get(packageName);
    }

    private DocumentationManager(String packageName) {
        this.resourceTree = ResourceTree.getInstance(packageName);
    }

    public WadlApplication getDocumentation(String path, Configuration config) {
        WadlApplication application = new WadlApplication();
        ArrayList<WadlResource> resources = new ArrayList<WadlResource>(1);
        resources.add(this.getResource(path, config));
        application.setResources(resources);
        return application;
    }

    protected WadlResource getResource(String path, Configuration configuration) {
        ResourceNode resourceNode = this.resourceTree.findResourceNode(path);
        if (resourceNode == null) {
            return null;
        }
        Class<?> resourceClass = resourceNode.getResourceClass();
        List<Method> resourceMethods = resourceNode.getResourceMethods();
        WadlResource resource = new WadlResource();
        resource.setPath(resourceNode.getPath());
        if (resourceClass != null && resourceMethods != null && resourceMethods.size() > 0) {
            resource.setParams(this.getResourceParams(resourceClass, resourceMethods.get(0)));
            resource.setMethods(this.getMethods(resourceMethods, configuration));
            resource.setResources(this.getSubResources(path));
        }
        return resource;
    }

    protected List<WadlResource> getSubResources(String path) {
        LinkedList<WadlResource> resources = new LinkedList<WadlResource>();
        for (ResourceNode resourceNode : this.resourceTree.findResourceNodesInPathSkippingRoot(path)) {
            WadlResource resource = new WadlResource();
            resource.setPath(resourceNode.getPath());
            resources.add(resource);
        }
        return resources;
    }

    protected List<WadlMethod> getMethods(List<Method> resourceMethods, Configuration configuration) {
        LinkedList<WadlMethod> methods = new LinkedList<WadlMethod>();
        for (Method resourceMethod : resourceMethods) {
            WadlMethod method = new WadlMethod();
            method.setName(AnnotationUtils.getHttpMethod(resourceMethod));
            method.setRequest(this.getRequest(resourceMethod, configuration));
            method.setResponses(this.getResponses(resourceMethod, configuration));
            methods.add(method);
        }
        return methods;
    }

    protected List<WadlResponse> getResponses(Method resourceMethod, Configuration configuration) {
        ArrayList<WadlResponse> responses = new ArrayList<WadlResponse>(1);
        WadlResponse response = new WadlResponse();
        if (!resourceMethod.getReturnType().equals(Void.TYPE)) {
            response.setStatus(HttpStatusCode.OK.getCode());
            response.setRepresentations(this.getResponseRepresentations(resourceMethod, configuration));
        } else {
            response.setStatus(HttpStatusCode.NoContent.getCode());
            response.setRepresentations(Collections.<WadlRepresentation>emptyList());
        }
        responses.add(response);
        return responses;
    }

    protected WadlRequest getRequest(Method resourceMethod, Configuration configuration) {
        WadlRequest request = new WadlRequest();
        request.setParams(this.getRequestParams(resourceMethod));
        request.setRepresentations(this.getRequestRepresentations(resourceMethod, configuration));
        return request;
    }

    protected List<WadlParam> filterNoneTemplateParams(List<WadlParam> params) {
        LinkedList<WadlParam> noneTemplateParams = new LinkedList<WadlParam>();
        for (WadlParam param : params) {
            if (param.getStyle().equals((Object)WadlParamStyle.TEMPLATE)) continue;
            noneTemplateParams.add(param);
        }
        return noneTemplateParams;
    }

    protected List<WadlParam> filterTemplateParams(List<WadlParam> params) {
        LinkedList<WadlParam> templateParams = new LinkedList<WadlParam>();
        for (WadlParam param : params) {
            if (!param.getStyle().equals((Object)WadlParamStyle.TEMPLATE)) continue;
            templateParams.add(param);
        }
        return templateParams;
    }

    protected List<WadlParam> getResourceParams(Class<?> resourceClass, Method resourceMethod) {
        List<WadlParam> classParams = this.getClassParams(resourceClass);
        List<WadlParam> methodParams = this.getMethodParams(resourceMethod);
        ArrayList<WadlParam> allParams = new ArrayList<WadlParam>(classParams.size() + methodParams.size());
        allParams.addAll(classParams);
        allParams.addAll(methodParams);
        HashSet<WadlParam> resourceParams = new HashSet<WadlParam>();
        resourceParams.addAll(this.filterTemplateParams(allParams));
        resourceParams.addAll(this.filterNoneTemplateParams(classParams));
        return new ArrayList<WadlParam>(resourceParams);
    }

    protected List<WadlParam> getRequestParams(Method resourceMethod) {
        List<WadlParam> methodParams = this.getMethodParams(resourceMethod);
        return this.filterNoneTemplateParams(methodParams);
    }

    protected List<WadlParam> getMethodParams(Method resourceMethod) {
        LinkedList<WadlParam> params = new LinkedList<WadlParam>();
        for (Annotation[] annotations : ClassManager.getInstance(resourceMethod).getMethodParameterAnnotations(resourceMethod, Param.class)) {
            String defaultValue = null;
            for (Annotation ann : annotations) {
                if (!ann.annotationType().equals(DefaultValue.class)) continue;
                defaultValue = this.defaultValuesAsString(((DefaultValue)ann).value());
                break;
            }
            for (Annotation ann : annotations) {
                if (!ann.annotationType().equals(Param.class)) continue;
                String paramName = ((Param)ann).value();
                WadlParam param = this.getParam(paramName, defaultValue);
                params.add(param);
            }
        }
        return params;
    }

    protected List<WadlParam> getClassParams(Class<?> resourceClass) {
        LinkedList<WadlParam> params = new LinkedList<WadlParam>();
        for (Field field : AnnotationUtils.getParamFieldsFromClass(resourceClass)) {
            String paramName = AnnotationUtils.getParamFromProperty(field);
            String defaultValue = this.defaultValuesAsString(AnnotationUtils.getDefaultValuesFromProperty(field));
            if (paramName.isEmpty()) {
                paramName = field.getName();
            }
            WadlParam param = this.getParam(paramName, defaultValue);
            params.add(param);
        }
        return params;
    }

    protected WadlParam getParam(String paramName, String defaultValue) {
        WadlParam param = new WadlParam();
        if (RegExUtils.FIND_ENCLOSED_BY_CURLY_BRACKETS.matcher(paramName).matches()) {
            param.setName(RegExUtils.getParamNameFromPathPart(paramName, false));
            param.setStyle(WadlParamStyle.TEMPLATE);
        } else {
            param.setName(paramName);
            param.setStyle(WadlParamStyle.QUERY);
            if (defaultValue == null) {
                param.setRequired(true);
            } else {
                param.setRequired(false);
                param.setDefaultValue(defaultValue);
            }
        }
        return param;
    }

    protected List<WadlRepresentation> getRequestRepresentations(Method method, Configuration configuration) {
        String httpMethod = AnnotationUtils.getHttpMethod(method);
        if (!httpMethod.equals("POST") && !httpMethod.equals("PUT")) {
            return Collections.emptyList();
        }
        Class<?> consumerClass = AnnotationUtils.getConsumerFromMethodOrClass(method);
        if (consumerClass == null) {
            consumerClass = configuration.getDefaultConsumer();
        }
        List<String> supportedMediaTypes = AnnotationUtils.getSupportedConsumerMediaTypes(consumerClass);
        return this.getRepresentations(supportedMediaTypes);
    }

    protected List<WadlRepresentation> getResponseRepresentations(Method method, Configuration configuration) {
        Class<?> producerClass = AnnotationUtils.getProducerFromMethodOrClass(method);
        if (producerClass == null) {
            producerClass = configuration.getDefaultProducer();
        }
        List<String> supportedMediaTypes = AnnotationUtils.getSupportedProducerMediaTypes(producerClass);
        return this.getRepresentations(supportedMediaTypes);
    }

    protected List<WadlRepresentation> getRepresentations(List<String> supportedMediaTypes) {
        Collections.sort(supportedMediaTypes);
        ArrayList<WadlRepresentation> representations = new ArrayList<WadlRepresentation>(supportedMediaTypes.size());
        for (String media : supportedMediaTypes) {
            WadlRepresentation representation = new WadlRepresentation();
            representation.setMediaType(media);
            representations.add(representation);
        }
        return representations;
    }

    protected String defaultValuesAsString(String[] defaultValues) {
        String defaultValue = "";
        if (defaultValues == null) {
            return null;
        }
        if (defaultValues.length == 1) {
            return defaultValues[0];
        }
        defaultValue = defaultValue + "{";
        for (String value : defaultValues) {
            defaultValue = defaultValue + value + ", ";
        }
        defaultValue = defaultValue.substring(0, defaultValue.length() - 2);
        defaultValue = defaultValue + "}";
        return defaultValue;
    }
}

