/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.constants;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HttpStatusCode {
    Continue(100, "Continue"),
    SwitchingProtocols(101, "Switching Protocols"),
    Processing(102, "Processing"),
    OK(200, "OK"),
    Created(201, "Created"),
    Accepted(202, "Accepted"),
    NonAuthoritativeInformation(203, "Non-Authoritative Information"),
    NoContent(204, "No Content"),
    ResetContent(205, "Reset Content"),
    PartialContent(206, "Partial Content"),
    MultiStatus(207, "Multi-Status"),
    MultipleChoice(300, "Multiple Choice"),
    MovedPermanently(301, "Moved Permanently"),
    Found(302, "Found"),
    SeeOther(303, "See Other"),
    NotModified(304, "Not Modified"),
    UseProxy(305, "Use Proxy"),
    TemporaryRedirect(307, "Temporary Redirect"),
    BadRequest(400, "Bad Request"),
    Unauthorized(401, "Unauthorized"),
    Forbidden(403, "Forbidden"),
    NotFound(404, "NotFound"),
    MethodNotAllowed(405, "Method Not Allowed"),
    NotAcceptable(406, "Not Acceptable"),
    ProxyAuthenticationRequired(407, "Proxy Authentication Required"),
    RequestTimeOut(408, "Request Time-out"),
    Conflict(409, "Conflict"),
    Gone(410, "Gone"),
    LengthRequired(411, "411 Length Required"),
    PreconditionFailed(412, "Precondition Failed"),
    RequestEntityTooLarge(413, "RequestEntityTooLarge"),
    RequestURITooLong(414, "Request-URI Too Long"),
    UnsupportedMediaType(415, "Unsupported Media Type"),
    RequestedRangeNotSatisfiable(416, "Requested range not satisfiable"),
    ExpectationFailed(417, "Expectation Failed"),
    ThereAreToManyConnectionsFromYourInternetAddress(421, "There are too many connections from your internet address"),
    UnprocessableEntity(422, "Unprocessable Entity"),
    Locked(423, "Locked"),
    FailedDependency(424, "Failed Dependency"),
    UnorderedCollection(425, "Unordered Collection"),
    UpgradeRequired(426, "Upgrade Required"),
    InternalServerError(500, "Internal Server Error"),
    NotImplemented(501, "Not Implemented"),
    BadGateway(502, "Bad Gateway"),
    ServiceUnavailable(503, "Service Unavailable"),
    GatewayTimeOut(504, "Gateway Time-out"),
    HTTPVersionNotSupported(505, "HTTP Version not supported"),
    VariantAlsoNegotiates(506, "Variant Also Negotiates"),
    InsufficientStorage(507, "Insufficient Storage"),
    BandwidthLimitExceeded(509, "Bandwidth Limit Exceeded"),
    NotExtended(510, "Not Extended");

    private static Map<Integer, HttpStatusCode> lookUpMap;
    private int code;
    private String name;

    private HttpStatusCode(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public HttpStatusCode getHttpStatusCode(int code) {
        return lookUpMap.get(code);
    }

    static {
        lookUpMap = new HashMap<Integer, HttpStatusCode>();
        lookUpMap.put(100, Continue);
        lookUpMap.put(101, SwitchingProtocols);
        lookUpMap.put(102, Processing);
        lookUpMap.put(200, OK);
        lookUpMap.put(201, Created);
        lookUpMap.put(202, Accepted);
        lookUpMap.put(203, NonAuthoritativeInformation);
        lookUpMap.put(204, NoContent);
        lookUpMap.put(205, ResetContent);
        lookUpMap.put(206, PartialContent);
        lookUpMap.put(207, MultiStatus);
        lookUpMap.put(300, MultipleChoice);
        lookUpMap.put(301, MovedPermanently);
        lookUpMap.put(302, Found);
        lookUpMap.put(303, SeeOther);
        lookUpMap.put(304, NotModified);
        lookUpMap.put(305, UseProxy);
        lookUpMap.put(307, TemporaryRedirect);
        lookUpMap.put(400, BadRequest);
        lookUpMap.put(401, Unauthorized);
        lookUpMap.put(403, Forbidden);
        lookUpMap.put(404, NotFound);
        lookUpMap.put(405, MethodNotAllowed);
        lookUpMap.put(406, NotAcceptable);
        lookUpMap.put(407, ProxyAuthenticationRequired);
        lookUpMap.put(408, RequestTimeOut);
        lookUpMap.put(409, Conflict);
        lookUpMap.put(410, Gone);
        lookUpMap.put(411, LengthRequired);
        lookUpMap.put(412, PreconditionFailed);
        lookUpMap.put(413, RequestEntityTooLarge);
        lookUpMap.put(414, RequestURITooLong);
        lookUpMap.put(415, UnsupportedMediaType);
        lookUpMap.put(416, RequestedRangeNotSatisfiable);
        lookUpMap.put(417, ExpectationFailed);
        lookUpMap.put(421, ThereAreToManyConnectionsFromYourInternetAddress);
        lookUpMap.put(422, UnprocessableEntity);
        lookUpMap.put(423, Locked);
        lookUpMap.put(424, FailedDependency);
        lookUpMap.put(425, UnorderedCollection);
        lookUpMap.put(426, UpgradeRequired);
        lookUpMap.put(500, InternalServerError);
        lookUpMap.put(501, NotImplemented);
        lookUpMap.put(502, BadGateway);
        lookUpMap.put(503, ServiceUnavailable);
        lookUpMap.put(504, GatewayTimeOut);
        lookUpMap.put(505, HTTPVersionNotSupported);
        lookUpMap.put(506, VariantAlsoNegotiates);
        lookUpMap.put(507, InsufficientStorage);
        lookUpMap.put(509, BandwidthLimitExceeded);
        lookUpMap.put(510, NotExtended);
    }
}

