/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.allocation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.craftforge.essential.controller.allocation.ResourceNode;
import net.craftforge.essential.controller.utils.AnnotationUtils;
import net.craftforge.essential.controller.utils.UriUtils;
import net.craftforge.reflection.managers.ClassManager;
import net.craftforge.reflection.utils.PackageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceTree.class);
    private static final ResourceNodeComparator RESOURCE_NODE_COMPARATOR = new ResourceNodeComparator();
    private static ConcurrentMap<String, ResourceTree> instances = new ConcurrentHashMap<String, ResourceTree>();
    private ResourceNode root = new ResourceNode(new String[]{"/"}, 0);

    public static ResourceTree getInstance(String packageName) {
        if (!instances.containsKey(packageName)) {
            LOGGER.info("[Resource tree initialization] {} ", (Object)packageName);
            instances.putIfAbsent(packageName, new ResourceTree(packageName));
        }
        return (ResourceTree)instances.get(packageName);
    }

    private ResourceTree(String packageName) {
        List<Class<?>> resourceClasses = PackageUtils.findClasses(packageName);
        for (Class<?> resourceClass : resourceClasses) {
            String pathForClass;
            if (Modifier.isAbstract(resourceClass.getModifiers()) || (pathForClass = AnnotationUtils.getPathFromClass(resourceClass)) == null) continue;
            for (Method resourceMethod : ClassManager.getInstance(resourceClass).getCompleteClassHierarchyMethods()) {
                String httpMethod = AnnotationUtils.getHttpMethod(resourceMethod);
                if (httpMethod == null) continue;
                this.addResourceMethod(resourceClass, resourceMethod);
            }
        }
    }

    public ResourceNode findResourceNode(String path) {
        path = UriUtils.standardUri(path);
        String[] pathParts = UriUtils.splitPath(path);
        return this.root.findResourceNode(pathParts);
    }

    public List<ResourceNode> findResourceNodesAlongPath(String path) {
        path = UriUtils.standardUri(path);
        String[] pathParts = UriUtils.splitPath(path);
        List<ResourceNode> resourceNodes = this.root.findResourceNodesAlongPath(pathParts);
        Collections.reverse(resourceNodes);
        return resourceNodes;
    }

    public List<ResourceNode> findResourceNodesInPathSkippingRoot(String path) {
        String[] pathParts = UriUtils.splitPath(path = UriUtils.standardUri(path));
        ResourceNode baseNode = this.root.findResourceNode(pathParts);
        if (baseNode == null) {
            return null;
        }
        List<ResourceNode> resourceNodes = baseNode.findAllSubNodesSkippingRoot();
        Collections.sort(resourceNodes, RESOURCE_NODE_COMPARATOR);
        return resourceNodes;
    }

    private void addResourceMethod(Class<?> resourceClass, Method resourceMethod) {
        String path = AnnotationUtils.getPathFromClass(resourceClass);
        String pathForMethod = AnnotationUtils.getPathFromMethod(resourceMethod);
        if (pathForMethod != null) {
            path = path + pathForMethod;
        }
        String[] pathParts = UriUtils.splitPath(path);
        this.root.addResourceMethod(pathParts, 0, resourceClass, resourceMethod);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceNodeComparator
    implements Comparator<ResourceNode> {
        private ResourceNodeComparator() {
        }

        @Override
        public int compare(ResourceNode o1, ResourceNode o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    }
}

