/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.allocation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.craftforge.essential.controller.utils.RegExUtils;
import net.craftforge.essential.controller.utils.UriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceNode {
    private String path;
    private String pathPart;
    private Pattern pattern = null;
    private int level;
    private Map<String, ResourceNode> trivialPattenSubNodes = new HashMap<String, ResourceNode>();
    private List<ResourceNode> noneTrivialPatternSubNodes = new LinkedList<ResourceNode>();
    private Class<?> resourceClass = null;
    private List<Method> resourceMethods = new ArrayList<Method>(4);

    public ResourceNode(String[] pathParts, int level) {
        this.level = level;
        this.path = this.getPathFromPathParts(pathParts);
        this.pathPart = pathParts[level];
        String regEx = RegExUtils.getRegExFromPathPart(this.pathPart);
        this.pattern = Pattern.compile(regEx);
    }

    public int getLevel() {
        return this.level;
    }

    public String getPath() {
        return this.path;
    }

    public String getPathPart() {
        return this.pathPart;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public List<Method> getResourceMethods() {
        return this.resourceMethods;
    }

    public void addResourceMethod(String[] pathParts, int level, Class<?> resourceClass, Method resourceMethod) {
        if (level == pathParts.length - 1) {
            this.resourceClass = resourceClass;
            this.resourceMethods.add(resourceMethod);
        } else {
            int nextLevel = level + 1;
            ResourceNode nextNode = this.findSubNodeFromVirtualPathPart(pathParts[nextLevel]);
            if (nextNode == null) {
                nextNode = new ResourceNode(pathParts, nextLevel);
                if (nextNode.getPattern().pattern().equals(nextNode.getPathPart())) {
                    this.trivialPattenSubNodes.put(nextNode.getPathPart(), nextNode);
                } else {
                    this.noneTrivialPatternSubNodes.add(nextNode);
                }
            }
            nextNode.addResourceMethod(pathParts, nextLevel, resourceClass, resourceMethod);
        }
    }

    private ResourceNode findSubNodeFromVirtualPathPart(String pathPart) {
        ResourceNode simpleNode = this.trivialPattenSubNodes.get(pathPart);
        if (simpleNode != null) {
            return simpleNode;
        }
        for (ResourceNode patternNode : this.noneTrivialPatternSubNodes) {
            if (!patternNode.getPathPart().equals(pathPart)) continue;
            return patternNode;
        }
        return null;
    }

    public ResourceNode findResourceNode(String[] pathParts) {
        if (this.level == pathParts.length - 1) {
            return this;
        }
        int nextLevel = this.level + 1;
        ResourceNode nextNode = this.findSubNode(pathParts[nextLevel]);
        if (nextNode == null) {
            return null;
        }
        return nextNode.findResourceNode(pathParts);
    }

    public List<ResourceNode> findResourceNodesAlongPath(String[] pathParts) {
        int nextLevel;
        ResourceNode nextNode;
        List<Object> resourceNodes = this.level == pathParts.length - 1 ? new ArrayList<ResourceNode>(this.level) : ((nextNode = this.findSubNode(pathParts[nextLevel = this.level + 1])) == null ? new ArrayList(this.level) : nextNode.findResourceNodesAlongPath(pathParts));
        resourceNodes.add(this);
        return resourceNodes;
    }

    public List<ResourceNode> findAllSubNodes() {
        return this.findAllSubNodes(false);
    }

    public List<ResourceNode> findAllSubNodesSkippingRoot() {
        return this.findAllSubNodes(true);
    }

    private List<ResourceNode> findAllSubNodes(boolean skip) {
        LinkedList<ResourceNode> resourceNodes = new LinkedList<ResourceNode>();
        if (!skip) {
            resourceNodes.add(this);
        }
        for (String key : this.trivialPattenSubNodes.keySet()) {
            ResourceNode subNode = this.trivialPattenSubNodes.get(key);
            resourceNodes.addAll(subNode.findAllSubNodes(false));
        }
        for (ResourceNode subNode : this.noneTrivialPatternSubNodes) {
            resourceNodes.addAll(subNode.findAllSubNodes(false));
        }
        return resourceNodes;
    }

    private ResourceNode findSubNode(String pathPart) {
        ResourceNode simpleNode = this.trivialPattenSubNodes.get(pathPart);
        if (simpleNode != null) {
            return simpleNode;
        }
        for (ResourceNode patternNode : this.noneTrivialPatternSubNodes) {
            if (!patternNode.getPattern().matcher(pathPart).matches()) continue;
            return patternNode;
        }
        return null;
    }

    private String getPathFromPathParts(String[] pathParts) {
        String path = "";
        for (int i = 0; i <= this.level; ++i) {
            path = path + "/" + pathParts[i];
        }
        return UriUtils.standardUri(path);
    }
}

