/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.Request;
import net.craftforge.essential.controller.Response;
import net.craftforge.essential.controller.managers.BodyHandler;
import net.craftforge.essential.controller.managers.DocumentationManager;
import net.craftforge.essential.controller.managers.HeaderHandler;
import net.craftforge.essential.controller.managers.ParameterHandler;
import net.craftforge.essential.controller.managers.PropertyHandler;
import net.craftforge.essential.controller.managers.ResourceManager;
import net.craftforge.essential.controller.utils.UriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Setup {
    private ResourceManager resourceManager;
    private DocumentationManager documentationManager;
    private Configuration configuration;
    private ParameterHandler parameterHandler;
    private HeaderHandler headerHandler;
    private BodyHandler bodyHandler;
    private PropertyHandler propertyHandler;
    private Request request;
    private Response response;

    public Setup(ResourceManager resourceManager, DocumentationManager documentationManager, Configuration configuration, Request request, Response response) {
        this.resourceManager = resourceManager;
        this.documentationManager = documentationManager;
        this.configuration = configuration;
        this.request = request;
        this.response = response;
        this.bodyHandler = new BodyHandler(request.getBodyInputStream());
        this.parameterHandler = new ParameterHandler(this.getAllParameters());
        this.headerHandler = new HeaderHandler(request.getHeaders());
        this.propertyHandler = new PropertyHandler(configuration);
    }

    public ParameterHandler getParameterHandler() {
        return this.parameterHandler;
    }

    public HeaderHandler getHeaderHandler() {
        return this.headerHandler;
    }

    public BodyHandler getBodyHandler() {
        return this.bodyHandler;
    }

    public PropertyHandler getPropertyHandler() {
        return this.propertyHandler;
    }

    public String getAcceptedMediaType() throws ControllerException {
        String metaDataPart = this.getRequestUrlMetaPart();
        if (metaDataPart.contains(".xml")) {
            return "text/xml";
        }
        if (metaDataPart.contains(".json")) {
            return "text/json";
        }
        return this.headerHandler.getHeaderValue("Accept", "text/xml");
    }

    public String getAcceptedCharset() throws ControllerException {
        return this.headerHandler.getHeaderValue("Accept-Charset", "UTF-8");
    }

    public String getHttpMethod() {
        String metaDataPart = this.getRequestUrlMetaPart();
        if (metaDataPart.contains(".get")) {
            return "GET";
        }
        if (metaDataPart.contains(".post")) {
            return "POST";
        }
        if (metaDataPart.contains(".put")) {
            return "PUT";
        }
        if (metaDataPart.contains(".delete")) {
            return "DELETE";
        }
        if (metaDataPart.contains(".head")) {
            return "HEAD";
        }
        if (metaDataPart.contains(".options")) {
            return "OPTIONS";
        }
        if (metaDataPart.contains(".trace")) {
            return "TRACE";
        }
        return this.request.getHttpMethod().toUpperCase();
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public DocumentationManager getDocumentationManager() {
        return this.documentationManager;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getRequestUrlResourcePart() {
        String pathInfo = this.getRequestUrlInfoPart();
        if (pathInfo.contains(".")) {
            pathInfo = pathInfo.substring(0, pathInfo.indexOf("."));
        }
        return UriUtils.standardUri(pathInfo);
    }

    public String getRequestUrlMetaPart() {
        String pathInfo = this.getRequestUrlInfoPart();
        if (!pathInfo.contains(".")) {
            return "";
        }
        return pathInfo.substring(pathInfo.indexOf(".") - 1, pathInfo.length());
    }

    public String getRequestUrlInfoPart() {
        return this.request.getUrlInfoPart();
    }

    public Map<String, String[]> getQueryParameters() {
        return this.request.getParameters();
    }

    public Map<String, String[]> getPathParameters() {
        return this.resourceManager.getPathParameters(this.getRequestUrlResourcePart());
    }

    public Map<String, String[]> getAllParameters() {
        Map<String, String[]> pathParameters;
        HashMap<String, String[]> allParameters = new HashMap<String, String[]>();
        Map<String, String[]> queryParameters = this.getQueryParameters();
        if (queryParameters != null) {
            allParameters.putAll(queryParameters);
        }
        if ((pathParameters = this.getPathParameters()) != null) {
            allParameters.putAll(pathParameters);
        }
        return allParameters;
    }

    public InputStream getRequestBodyInputStream() {
        return this.request.getBodyInputStream();
    }

    public OutputStream getResponseBodyOutputStream() {
        return this.response.getBodyOutputStream();
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }
}

