/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.craftforge.essential.context.basic.BasicRequestImpl;
import net.craftforge.essential.context.basic.BasicResponseImpl;
import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.Phase;
import net.craftforge.essential.controller.Request;
import net.craftforge.essential.controller.Response;
import net.craftforge.essential.controller.Setup;
import net.craftforge.essential.controller.State;
import net.craftforge.essential.controller.managers.DocumentationManager;
import net.craftforge.essential.controller.managers.ResourceManager;
import net.craftforge.essential.controller.phases.flow.PhaseFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(Controller.class);
    private ResourceManager resourceManager;
    private DocumentationManager documentationManager;
    private Configuration config;

    public static Controller getInstance(String packagePath, Configuration config) {
        return new Controller(packagePath, config);
    }

    public static Controller getInstance(String packagePath) {
        return Controller.getInstance(packagePath, new Configuration());
    }

    private Controller(String packagePath, Configuration config) {
        LOGGER.debug("[Starting controller initialization] {}", (Object)packagePath);
        this.resourceManager = ResourceManager.getInstance(packagePath);
        this.documentationManager = DocumentationManager.getInstance(packagePath);
        this.config = config;
        LOGGER.debug("[Finished controller initialization] {}", (Object)packagePath);
    }

    public int perform(String httpMethod, String urlInfoPart, Map<String, String[]> requestHeaders, Map<String, String[]> requestParameters, InputStream inputStream, OutputStream outputStream) throws ControllerException {
        return this.perform(new BasicRequestImpl(httpMethod, urlInfoPart, requestHeaders, requestParameters, inputStream), new BasicResponseImpl(outputStream));
    }

    public int perform(Request request, Response response) throws ControllerException {
        PhaseFlow flow;
        LOGGER.debug("[Starting request execution] {} {}", (Object)request.getHttpMethod(), (Object)request.getUrlInfoPart());
        State state = new State();
        Setup setup = new Setup(this.resourceManager, this.documentationManager, this.config, request, response);
        LOGGER.info("[Performing request] {} {}", (Object)setup.getHttpMethod(), (Object)setup.getRequestUrlResourcePart());
        Class<?> phaseFlowClass = this.config.getPhaseFlow();
        try {
            flow = (PhaseFlow)phaseFlowClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ControllerException("Unable to instantiate phase flow class " + phaseFlowClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ControllerException("Unable to instantiate phase flow class " + phaseFlowClass.getName(), e);
        }
        flow.setSetup(setup);
        flow.setState(state);
        Phase phase = flow.getFirstPhase();
        while (phase != null) {
            LOGGER.debug("[Running phase] {}", (Object)phase.getClass().getName());
            phase.run();
            phase = flow.getPhaseAfter(phase);
        }
        LOGGER.debug("[Finished request execution] {} {}", (Object)request.getHttpMethod(), (Object)request.getUrlInfoPart());
        return state.getStatus().getCode();
    }
}

