/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller;

import java.util.Map;
import net.craftforge.commons.configuration.PropertiesHolder;
import net.craftforge.essential.controller.phases.flow.StandardPhaseFlow;
import net.craftforge.essential.supply.jaxb.JaxbConsumer;
import net.craftforge.essential.supply.jaxb.JaxbProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
extends PropertiesHolder {
    public static final String DEFAULT_CONFIG_FILE = "essential.properties";
    public static final String PROPERTY_DEFAULT_CONSUMER = "io.consumer";
    public static final String PROPERTY_DEFAULT_PRODUCER = "io.producer";
    public static final String PROPERTY_PHASE_FLOW = "phase.flow";
    public static final String PROPERTY_AUTHENTICATION_HANDLER = "authentication.handler";
    public static final String PROPERTY_XML_DESERIALIZATION = "io.xml.in";
    public static final String PROPERTY_XML_SERIALIZATION = "io.xml.out";
    public static final String PROPERTY_JSON_DESERIALIZATION = "io.json.in";
    public static final String PROPERTY_JSON_SERIALIZATION = "io.json.out";
    public static final Class<?> DEFAULT_CONSUMER = JaxbConsumer.class;
    public static final Class<?> DEFAULT_PRODUCER = JaxbProducer.class;
    public static final Class<?> DEFAULT_PHASE_FLOW = StandardPhaseFlow.class;

    public Configuration() {
        this(DEFAULT_CONFIG_FILE);
    }

    public Configuration(String configFile) {
        super("/" + configFile);
    }

    public Class<?> getDefaultConsumer() {
        return this.getClass(PROPERTY_DEFAULT_CONSUMER, DEFAULT_CONSUMER);
    }

    public void setDefaultConsumer(Class<?> defaultConsumer) {
        this.setProperty(PROPERTY_DEFAULT_CONSUMER, defaultConsumer.getName());
    }

    public Class<?> getDefaultProducer() {
        return this.getClass(PROPERTY_DEFAULT_PRODUCER, DEFAULT_PRODUCER);
    }

    public void setDefaultProducer(Class<?> defaultProducer) {
        this.setProperty(PROPERTY_DEFAULT_PRODUCER, defaultProducer.getName());
    }

    public Class<?> getPhaseFlow() {
        return this.getClass(PROPERTY_PHASE_FLOW, DEFAULT_PHASE_FLOW);
    }

    public void setPhaseFlow(Class<?> phaseFlow) {
        this.setProperty(PROPERTY_PHASE_FLOW, phaseFlow.getName());
    }

    public Class<?> getAuthenticationHandler() {
        return this.getClass(PROPERTY_AUTHENTICATION_HANDLER, null);
    }

    public void setAuthenticationHandler(Class<?> authenticationHandler) {
        this.setProperty(PROPERTY_AUTHENTICATION_HANDLER, authenticationHandler.getName());
    }

    public Map<String, String> getXmlDeserializationProperties() {
        return this.getProperties(PROPERTY_XML_DESERIALIZATION);
    }

    public void setXmlDeserializationProperties(Map<String, String> xmlDeserializationProperties) {
        this.setProperties(PROPERTY_XML_DESERIALIZATION, xmlDeserializationProperties);
    }

    public Map<String, String> getJsonDeserializationProperties() {
        return this.getProperties(PROPERTY_JSON_DESERIALIZATION);
    }

    public void setJsonDeserializationProperties(Map<String, String> jsonDeserializationProperties) {
        this.setProperties(PROPERTY_JSON_DESERIALIZATION, jsonDeserializationProperties);
    }

    public Map<String, String> getXmlSerializationProperties() {
        return this.getProperties(PROPERTY_XML_SERIALIZATION);
    }

    public void setXmlSerializationProperties(Map<String, String> xmlSerializationProperties) {
        this.setProperties(PROPERTY_XML_SERIALIZATION, xmlSerializationProperties);
    }

    public Map<String, String> getJsonSerializationProperties() {
        return this.getProperties(PROPERTY_JSON_SERIALIZATION);
    }

    public void setJsonSerializationProperties(Map<String, String> jsonSerializationProperties) {
        this.setProperties(PROPERTY_JSON_SERIALIZATION, jsonSerializationProperties);
    }
}

