/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.context.basic;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import net.craftforge.essential.controller.Response;
import net.craftforge.essential.controller.constants.HttpStatusCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicResponseImpl
implements Response {
    private HttpStatusCode httpStatusCode;
    private Map<String, String[]> headers;
    private OutputStream outputStream;

    public BasicResponseImpl(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void sendHeaders(HttpStatusCode httpStatusCode, Map<String, String[]> headers) {
        this.httpStatusCode = httpStatusCode;
        this.headers = headers;
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, "UTF-8"));
            writer.write("HTTP/1.1 " + httpStatusCode.getCode() + " " + httpStatusCode.getName());
            writer.newLine();
            for (String headerName : headers.keySet()) {
                for (String headerValue : headers.get(headerName)) {
                    writer.write(headerName + ": " + headerValue);
                    writer.newLine();
                }
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to send response headers", e);
        }
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return this.httpStatusCode;
    }

    @Override
    public Map<String, String[]> getHeaders() {
        return this.headers;
    }

    @Override
    public OutputStream getBodyOutputStream() {
        return this.outputStream;
    }
}

