/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.craftforge.essential.client.Client;
import net.craftforge.essential.client.ClientRequest;
import net.craftforge.essential.client.ClientResponse;
import net.craftforge.essential.controller.utils.HeaderUtils;
import net.craftforge.essential.controller.utils.UriUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkClient
implements Client {
    private String urlBasePart;

    public NetworkClient(String urlBasePart) {
        this.urlBasePart = urlBasePart;
    }

    @Override
    public ClientResponse performRequest(ClientRequest clientRequest) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpRequestBase httpRequest = this.getHttpRequest(clientRequest);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
            return this.getClientResponse(httpResponse);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to perform http request", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URI", e);
        }
    }

    protected HttpRequestBase getHttpRequest(ClientRequest request) throws URISyntaxException {
        Object httpRequest;
        final String httpMethod = request.getHttpMethod();
        if (httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("PUT")) {
            HttpEntityEnclosingRequestBase entityRequest = new HttpEntityEnclosingRequestBase(){

                public String getMethod() {
                    return httpMethod;
                }
            };
            entityRequest.setEntity((HttpEntity)new InputStreamEntity(request.getRequestBody(), -1L));
            httpRequest = entityRequest;
        } else {
            httpRequest = new HttpRequestBase(){

                public String getMethod() {
                    return httpMethod;
                }
            };
            httpRequest.setParams(this.getRequestParameters(request.getParameters()));
        }
        String uriString = this.urlBasePart + "/" + request.getUrlInfoPart();
        uriString = UriUtils.slimUri(uriString);
        httpRequest.setURI(new URI(uriString));
        httpRequest.setHeaders(this.getRequestHeaders(request.getHeaders()));
        return httpRequest;
    }

    protected HttpParams getRequestParameters(Map<String, String[]> parameters) {
        BasicHttpParams httpParameters = new BasicHttpParams();
        for (String paramName : parameters.keySet()) {
            String[] paramValues = parameters.get(paramName);
            if (paramValues.length <= 0) continue;
            httpParameters.setParameter(paramName, (Object)paramValues[0]);
        }
        return httpParameters;
    }

    protected Header[] getRequestHeaders(Map<String, String[]> headers) {
        ArrayList<BasicHeader> httpHeaders = new ArrayList<BasicHeader>(headers.size());
        for (String headerName : headers.keySet()) {
            String[] headerValues;
            for (String headerValue : headerValues = headers.get(headerName)) {
                httpHeaders.add(new BasicHeader(headerName, headerValue));
            }
        }
        return httpHeaders.toArray(new Header[httpHeaders.size()]);
    }

    protected ClientResponse getClientResponse(HttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        InputStream inputStream = entity == null ? null : entity.getContent();
        return new ClientResponse(httpResponse.getStatusLine().getStatusCode(), this.getResponseHeaders(httpResponse.getAllHeaders()), inputStream);
    }

    protected Map<String, String[]> getResponseHeaders(Header[] headers) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>(headers.length * 2);
        for (Header header : headers) {
            String headerName = header.getName();
            ArrayList<String> headerValueList = (ArrayList<String>)responseHeaders.get(headerName);
            if (headerValueList == null) {
                headerValueList = new ArrayList<String>(1);
            }
            headerValueList.add(header.getValue());
            responseHeaders.put(headerName, headerValueList);
        }
        return HeaderUtils.normalizeHeaderMap(responseHeaders);
    }
}

