/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import net.craftforge.essential.client.Client;
import net.craftforge.essential.client.ClientRequest;
import net.craftforge.essential.client.ClientResponse;
import net.craftforge.essential.context.basic.BasicRequestImpl;
import net.craftforge.essential.context.basic.BasicResponseImpl;
import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.Controller;
import net.craftforge.essential.controller.ControllerException;

public class LocalClient
implements Client {
    private Controller controller;

    public LocalClient(String packagePath) {
        this.controller = Controller.getInstance(packagePath);
    }

    public LocalClient(String packagePath, Configuration config) {
        this.controller = Controller.getInstance(packagePath, config);
    }

    public ClientResponse performRequest(ClientRequest clientRequest) {
        BasicRequestImpl request = new BasicRequestImpl(clientRequest.getHttpMethod(), clientRequest.getUrlInfoPart(), clientRequest.getHeaders(), clientRequest.getParameters(), clientRequest.getRequestBody());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BasicResponseImpl response = new BasicResponseImpl(outputStream);
        try {
            this.controller.perform(request, response);
        }
        catch (ControllerException e) {
            throw new RuntimeException(e);
        }
        return new ClientResponse(response.getStatusCode().getCode(), response.getHeaders(), new ByteArrayInputStream(outputStream.toByteArray()));
    }
}

