/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.client;

import java.io.InputStream;
import java.util.Map;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.managers.BodyHandler;
import net.craftforge.essential.controller.managers.HeaderHandler;
import net.craftforge.essential.supply.Consumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientResponse {
    private int statusCode;
    private HeaderHandler headerHandler;
    private BodyHandler bodyHandler;

    public ClientResponse(int statusCode, Map<String, String[]> headers, InputStream bodyInputStream) {
        this.statusCode = statusCode;
        this.headerHandler = new HeaderHandler(headers);
        this.bodyHandler = new BodyHandler(bodyInputStream);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public InputStream getBodyInputStream() {
        return this.bodyHandler.getBodyInputStream();
    }

    public String getBodyContent() {
        String charset = this.getContentCharset();
        return this.bodyHandler.getBodyContent(charset);
    }

    public Object getBodyObject(Consumer consumer, Class<?> clazz) throws ControllerException {
        String mediaType = this.getContentMediaType();
        String charset = this.getContentCharset();
        return this.bodyHandler.getBodyObject(consumer, clazz, mediaType, charset);
    }

    public String getContentMediaType() {
        return this.headerHandler.getContentMediaType("text/xml");
    }

    public String getContentCharset() {
        return this.headerHandler.getContentCharset("UTF-8");
    }

    public String getAuthorizationUser() {
        return this.headerHandler.getAuthorizationUser();
    }

    public String getAuthorizationPassword() {
        return this.headerHandler.getAuthorizationPassword();
    }
}

