/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.utils.HeaderUtils;
import net.craftforge.essential.supply.Producer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRequest {
    private String httpMethod;
    private String urlInfoPart;
    private Map<String, String[]> headers = new HashMap<String, String[]>();
    private Map<String, String[]> parameters = new HashMap<String, String[]>();
    private InputStream requestBody;

    public ClientRequest(String httpMethod, String urlInfoPart) {
        this.httpMethod = httpMethod;
        this.urlInfoPart = urlInfoPart;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrlInfoPart() {
        return this.urlInfoPart;
    }

    public Map<String, String[]> getHeaders() {
        return this.headers;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public InputStream getRequestBody() {
        return this.requestBody;
    }

    public void setAuthorization(String username, String password) {
        String headerValue = HeaderUtils.getBasicAuthorizationHeader(username, password);
        this.setHeader("Authorization", headerValue);
    }

    public void setBody(String bodyContent, String mediaType) {
        this.setBody(bodyContent, mediaType, "UTF-8");
    }

    public void setBody(String bodyContent, String mediaType, String charset) {
        ByteArrayInputStream bodyInputStream;
        try {
            bodyInputStream = new ByteArrayInputStream(bodyContent.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.setBody(bodyInputStream, mediaType, charset);
    }

    public void setBody(InputStream bodyInputStream, String mediaType) {
        this.setBody(bodyInputStream, mediaType, "UTF-8");
    }

    public void setBody(InputStream bodyInputStream, String mediaType, String charset) {
        this.requestBody = bodyInputStream;
        String headerValue = mediaType + "; charset=" + charset;
        this.setHeader("Content-Type", headerValue);
    }

    public void setBody(Object object, Producer producer, String mediaType) throws ControllerException {
        this.setBody(object, producer, mediaType, "UTF-8");
    }

    public void setBody(Object object, Producer producer, String mediaType, String charset) throws ControllerException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        producer.produce(mediaType, object, outputStream, charset);
        ByteArrayInputStream bodyInputStream = new ByteArrayInputStream(outputStream.toByteArray());
        this.setBody(bodyInputStream, mediaType, charset);
    }

    public void setHeader(String headerName, String headerValue) {
        String[] headerValues = new String[]{headerValue};
        this.setHeader(headerName, headerValues);
    }

    public void setHeader(String headerName, String[] headerValues) {
        this.headers.put(headerName, headerValues);
    }

    public void setHeaders(Map<String, String[]> headers) {
        this.headers = headers;
    }

    public void setParameter(String parameterName, String parameterValue) {
        String[] parameterValues = new String[]{parameterValue};
        this.setParameter(parameterName, parameterValues);
    }

    public void setParameter(String parameterName, String[] parameterValues) {
        this.parameters.put(parameterName, parameterValues);
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }
}

