/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamUtils {
    public static String readStringFromInputStream(InputStream inputStream, String charset) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        return StreamUtils.readStringFromInputStreamReader(inputStreamReader);
    }

    public static String readStringFromInputStreamReader(InputStreamReader inputStreamReader) throws IOException {
        int read;
        StringBuilder stringBuilder = new StringBuilder();
        char[] charBuffer = new char[8192];
        while ((read = inputStreamReader.read(charBuffer)) != -1) {
            stringBuilder.append(charBuffer, 0, read);
        }
        inputStreamReader.close();
        return stringBuilder.toString();
    }

    public static Object getObjectFromXmlOutputStream(Class<?> clazz, ByteArrayOutputStream outputStream, String charset) {
        Object result = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            result = unmarshaller.unmarshal((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), charset));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static InputStream getXmlInputStreamFromObject(Object object, String charset) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)outputStream, charset);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(object, (Writer)outputStreamWriter);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }
}

