/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.commons.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    private static Logger LOGGER = LoggerFactory.getLogger(PropertiesLoader.class);
    private static ConcurrentMap<String, PropertiesLoader> instances = new ConcurrentHashMap<String, PropertiesLoader>();
    private Properties properties = new Properties();

    public static Properties loadProperties(String resource) {
        if (!instances.containsKey(resource)) {
            LOGGER.info("[Property loader initialization] " + resource);
            instances.putIfAbsent(resource, new PropertiesLoader(resource));
        }
        Properties properties = ((PropertiesLoader)instances.get(resource)).getProperties();
        Properties propertiesCopy = new Properties();
        propertiesCopy.putAll((Map<?, ?>)properties);
        return propertiesCopy;
    }

    private PropertiesLoader(String resource) {
        InputStream is = this.getClass().getResourceAsStream(resource);
        if (is == null) {
            return;
        }
        try {
            this.properties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadProperties() {
    }

    private Properties getProperties() {
        return this.properties;
    }
}

