/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.commons.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.craftforge.commons.configuration.PropertiesLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesHolder {
    private Properties properties;
    private ConcurrentMap<String, Class<?>> classes = new ConcurrentHashMap();
    private ConcurrentMap<String, Map<String, String>> maps = new ConcurrentHashMap<String, Map<String, String>>();

    public PropertiesHolder(String resource) {
        this.properties = PropertiesLoader.loadProperties(resource);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.properties.setProperty(propertyName, propertyValue);
        this.removeClass(propertyName);
        this.removeMaps(propertyName);
    }

    public void setProperties(String propertyNamePrefix, Map<String, String> properties) {
        for (String key : properties.keySet()) {
            this.setProperty(propertyNamePrefix + "." + key, properties.get(key));
        }
    }

    public Map<String, String> getProperties(String propertyNamePrefix) {
        String prefix = propertyNamePrefix + ".";
        this.maps.putIfAbsent(prefix, this.createMap(prefix));
        return (Map)this.maps.get(prefix);
    }

    public Class<?> getClass(String propertyName, Class<?> defaultClass) {
        if (!this.classes.containsKey(propertyName)) {
            Class<?> clazz = this.createClass(propertyName, defaultClass);
            if (clazz == null) {
                return clazz;
            }
            this.classes.putIfAbsent(propertyName, clazz);
        }
        return (Class)this.classes.get(propertyName);
    }

    protected Class<?> createClass(String propertyName, Class<?> defaultClass) {
        String property = this.properties.getProperty(propertyName);
        if (property == null) {
            return defaultClass;
        }
        try {
            return Class.forName(property);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load configuration when processing property " + propertyName, e);
        }
    }

    protected Map<String, String> createMap(String prefix) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Object key : this.properties.keySet()) {
            String propertyName = (String)key;
            if (!propertyName.startsWith(prefix)) continue;
            String newKey = propertyName.replace(prefix, "");
            String newValue = this.properties.getProperty(propertyName);
            newMap.put(newKey, newValue);
        }
        return newMap;
    }

    protected void removeClass(String propertyName) {
        this.classes.remove(propertyName);
    }

    protected void removeMaps(String propertyName) {
        String[] propertyNameParts = propertyName.split(".");
        String currentPrefix = "";
        for (String part : propertyNameParts) {
            if (!currentPrefix.isEmpty()) {
                currentPrefix = currentPrefix + ".";
            }
            currentPrefix = currentPrefix + part;
            this.maps.remove(currentPrefix);
        }
    }
}

