/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.testsuite;

import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.testsuite.environment.mocks.MockAuthenticationHandler;

/**
 * Provides a predefined client test with test suite using a local and an HTTP client.
 *
 * @author Christian Bick
 * @since 07.07.11
 */
public class TestValues {
    public static String DEFAULT_BASE_URL = "http://localhost:8081/";
    public static String DEFAULT_PACKAGE_PATH = "net.craftforge.essential.testsuite.environment.resources";
    public static Configuration DEFAULT_CONFIGURATION;

    static {
        DEFAULT_CONFIGURATION = new Configuration();
        DEFAULT_CONFIGURATION.setAuthenticationHandler(MockAuthenticationHandler.class);
    }
}
