/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.testsuite;

import junit.framework.Assert;
import net.craftforge.essential.client.Client;
import net.craftforge.essential.client.ClientRequest;
import net.craftforge.essential.client.ClientResponse;
import net.craftforge.essential.controller.constants.HttpStatusCode;

/**
 * @author Christian Bick
 * @since 01.09.11
 */
public abstract class ClientTest {

    private Client client;

    public ClientTest(Client client) {
        this.client = client;
    }

    public ClientResponse testRequest(ClientRequest request, HttpStatusCode expectedStatus) {
        return testRequest(request, expectedStatus.getCode());
    }

    public ClientResponse testRequest(ClientRequest request, int expectedStatus) {
        ClientResponse response = client.performRequest(request);
        Assert.assertEquals(expectedStatus, response.getStatusCode());
        return response;
    }

}
