/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.controller.phases.flow;

import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.Phase;
import net.craftforge.essential.controller.Setup;
import net.craftforge.essential.controller.State;

/**
 * A phase flow defines with which phase a controller starts and which phase
 * follows on another phase depending on the controller setup and state.
 *
 * @author Christian Bick
 * @since 30.05.2011
 */
public interface PhaseFlow {

    /**
     * Sets the controller state
     *
     * @param state The controller state
     */
    public void setState(State state);

    /**
     * Sets the controller setup
     *
     * @param setup The controller setup
     */
    public void setSetup(Setup setup);

    /**
     * Gets the controller phase to start with
     *
     * @return The controller phase to start with
     */
    public Phase getFirstPhase();

    /**
     * Gets the controller phase which follows after the given phase.
     *
     * @param phase The phase to estimate the following phase for
     * @return The following controller phase or null if no phase follows (last phase)
     * @throws ControllerException if the input phase is not known by the phase flow
     */
    public Phase getPhaseAfter(Phase phase) throws ControllerException;
}
