/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.controller.phases;

import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.Phase;
import net.craftforge.essential.controller.Setup;
import net.craftforge.essential.controller.State;
import net.craftforge.essential.controller.constants.HttpStatusCode;
import net.craftforge.essential.controller.documentation.jaxb.WadlApplication;
import net.craftforge.essential.controller.managers.DocumentationManager;

/**
 * Generates the documentation of the resource class and sets it as the result.
 *
 * @author Christian Bick
 * @since 20.07.11
 */
public class DocumentationPhase implements Phase {

    private State state;
    private Setup setup;

    /**
     * Creates a documentation phase from a controller state and setup.
     *
     * @param state The controller state
     * @param setup The controller setup
     */
    public DocumentationPhase(State state, Setup setup) {
        this.state = state;
        this.setup = setup;
    }

    /**
     * {@inheritDoc}
     */
    public void run() throws ControllerException {
        try {
            DocumentationManager documentationManager = setup.getDocumentationManager();
            WadlApplication application = documentationManager.getDocumentation(setup.getRequestUrlResourcePart(), setup.getConfiguration());
            state.setStatus(HttpStatusCode.OK);
            state.setResult(application);
        } catch (RuntimeException e) {
            throw new ControllerException("An unexpected exception occurred during resource documentation", e);
        }
    }

}
