/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.controller.managers;

import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.ControllerException;

import java.util.Collections;
import java.util.Map;

/**
 * @author Christian Bick
 * @since 27.08.11
 */
public class PropertyHandler {

    private Configuration configuration;

    public PropertyHandler(Configuration configuration) {
        this.configuration = configuration;
    }

    public Map<String, String> getProperties(String propertyName, String[] defaultValues) throws ControllerException {
        Map<String, String> result = configuration.getProperties(propertyName);
        if (result == null || result.isEmpty()) {
            if (defaultValues == null) {
                throw new ControllerException("At least one configuration property with prefix " + propertyName + " is " +
                        "expected to be passed in the configuration but is missing");
            } else {
                result = Collections.emptyMap();
            }
        }
        return result;
    }

    public String getProperty (String propertyName, String[] defaultValues) throws ControllerException {
        String result = configuration.getProperty(propertyName);
        if (result == null) {
            if (defaultValues == null || defaultValues.length < 1) {
                throw new ControllerException("The configuration property " + propertyName + " is " +
                        "expected to be passed in the configuration but is missing");
            } else {
                result = defaultValues[0];
            }
        }
        return result;
    }

}
