/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.controller.managers;

import net.craftforge.commons.io.StreamUtils;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.supply.Consumer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author Christian Bick
 * @since 21.08.11
 */
public class BodyHandler {

    private InputStream bodyInputStream;

    public BodyHandler (InputStream bodyInputStream) {
        this.bodyInputStream = bodyInputStream;
    }

    public InputStream getBodyInputStream() {
        return bodyInputStream;
    }

    public String getBodyContent(String charset) {
        String bodyAsString;
        try {
            bodyAsString = StreamUtils.readStringFromInputStream(bodyInputStream, charset);
            bodyInputStream = new ByteArrayInputStream(bodyAsString.getBytes());
        } catch (IOException e) {
            throw new RuntimeException("Failed to read http request body", e);
        }
        return bodyAsString;
    }

    public Object getBodyObject(Consumer consumer, Class<?> type, String mediaType, String charset) throws ControllerException {
        return consumer.consume(type, mediaType, bodyInputStream, charset);
    }
}
