/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.controller.handlers;

import net.craftforge.essential.controller.Setup;

/**
 * An authentication handler authenticates a request using the request setup. An implementation may
 * for example compare the authorization header contents with credentials from a database.
 *
 * @author Christian Bick
 * @since 22.05.2011
 */
public interface AuthenticationHandler {

    /**
     * Authenticates a requester using the request setup.
     *
     * @param setup The request setup
     * @return whether the requester could be authenticated or not
     */
    public boolean authenticate(Setup setup);
}
