package net.craftforge.essential.controller.documentation.jaxb;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.List;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "resource_type")
public class WadlResourceType {

    @XmlAttribute
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    private String id;

    @XmlElement(name = "doc")
    private WadlDoc doc;

    @XmlElement(name = "param")
    private List<WadlParam> params;

    @XmlElement(name = "resource")
    private List<WadlMethod> methods;

    @XmlElement(name = "resource")
    private List<WadlResource> resources;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WadlDoc getDoc() {
        return doc;
    }

    public void setDoc(WadlDoc doc) {
        this.doc = doc;
    }

    public List<WadlParam> getParams() {
        return params;
    }

    public void setParams(List<WadlParam> params) {
        this.params = params;
    }

    public List<WadlMethod> getMethods() {
        return methods;
    }

    public void setMethods(List<WadlMethod> methods) {
        this.methods = methods;
    }

    public List<WadlResource> getResources() {
        return resources;
    }

    public void setResources(List<WadlResource> resources) {
        this.resources = resources;
    }
}
