package net.craftforge.essential.controller.documentation.jaxb;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.List;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "resource")
public class WadlResource {

    @XmlAttribute
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    private String id;

    @XmlAttribute
    private List<String> type;

    @XmlAttribute
    private String queryType;

    @XmlAttribute
    private String path;

    @XmlElement(name = "doc")
    private WadlDoc doc;

    @XmlElement(name = "param")
    private List<WadlParam> params;

    @XmlElement(name = "method")
    private List<WadlMethod> methods;

    @XmlElement(name = "resource")
    private List<WadlResource> resources;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getType() {
        return type;
    }

    public void setType(List<String> type) {
        this.type = type;
    }

    public String getQueryType() {
        return queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public WadlDoc getDoc() {
        return doc;
    }

    public void setDoc(WadlDoc doc) {
        this.doc = doc;
    }

    public List<WadlParam> getParams() {
        return params;
    }

    public void setParams(List<WadlParam> params) {
        this.params = params;
    }

    public List<WadlMethod> getMethods() {
        return methods;
    }

    public void setMethods(List<WadlMethod> methods) {
        this.methods = methods;
    }

    public List<WadlResource> getResources() {
        return resources;
    }

    public void setResources(List<WadlResource> resources) {
        this.resources = resources;
    }
}
