package net.craftforge.essential.controller.documentation.jaxb;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import java.util.List;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "representation")
public class WadlRepresentation {

    @XmlAttribute
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    private String id;

    @XmlAttribute
    private QName element;

    @XmlAttribute
    private String mediaType;

    @XmlAttribute
    @XmlSchemaType(name = "anyURI")
    private String href;

    @XmlAttribute
    private String profile;

    @XmlElement(name = "doc")
    private WadlDoc doc;

    @XmlElement(name = "param")
    private List<WadlParam> params;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public QName getElement() {
        return element;
    }

    public void setElement(QName element) {
        this.element = element;
    }

    public String getMediaType() {
        return mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getProfile() {
        return profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public WadlDoc getDoc() {
        return doc;
    }

    public void setDoc(WadlDoc doc) {
        this.doc = doc;
    }

    public List<WadlParam> getParams() {
        return params;
    }

    public void setParams(List<WadlParam> params) {
        this.params = params;
    }
}
