package net.craftforge.essential.controller.documentation.jaxb;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.List;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "method")
public class WadlMethod {

    @XmlAttribute
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    private String id;

    @XmlAttribute
    private String name;

    @XmlAttribute
    @XmlSchemaType(name = "anyURI")
    private String href;

    @XmlElement(name = "request")
    private WadlRequest request;

    @XmlElement(name = "doc")
    private WadlDoc doc;

    @XmlElement(name = "response")
    private List<WadlResponse> responses;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public WadlRequest getRequest() {
        return request;
    }

    public void setRequest(WadlRequest request) {
        this.request = request;
    }

    public WadlDoc getDoc() {
        return doc;
    }

    public void setDoc(WadlDoc doc) {
        this.doc = doc;
    }

    public List<WadlResponse> getResponses() {
        return responses;
    }

    public void setResponses(List<WadlResponse> responses) {
        this.responses = responses;
    }
}
