/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.controller.constants;

/**
 * Internet media type constants.
 *
 * @author Christian Bick
 * @since 14.03.2011
 */
public class MediaType {

    /**
     * text/plain
     */
    public static final String TEXT_PLAIN = "text/plain";

    /**
     * text/xml
     */
    public static final String TEXT_XML = "text/xml";

    /**
     * text/json
     */
    public static final String TEXT_JSON = "text/json";

    /**
     * text/json
     */
    public static final String TEXT_HTML = "text/html";

    /**
     * application/x-www-form-urlencoded
     */
    public static final String X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
}
