/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */


package net.craftforge.essential.controller.annotations;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Indicates the default value(s) to use if no parameter was found for initializing a field or method parameter.
 * If the annotation is not present at a field or method parameter then the parameter is required.
 *
 * @author Christian Bick
 * @since 28.01.2011
 */
@Retention(value=RUNTIME)
@Target( { FIELD, PARAMETER })
public @interface DefaultValue {

    /**
     * The default value(s) to use if no parameter was found.
     *
     * @return The default value(s) as an array
     */
    String[] value();
}
