/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.controller;

import net.craftforge.essential.controller.constants.HttpStatusCode;

import java.lang.reflect.Method;
import java.util.Date;

/**
 * Represents the current state of a performing call.
 *
 * @author Christian Bick
 * @since 06.02.2011
 */
public class State {

    /**
     * The resource method
     */
    private Method resourceMethod;

    /**
     * The resource class
     */
    private Class<?> resourceClass;

    /**
     * The result
     */
    private Object result;

    /**
     * The HTTP status code
     */
    private HttpStatusCode status;

    /**
     * The invocation start date
     */
    private Date invocationStart;

    /**
     * The invocation end date
     */
    private Date invocationEnd;

    /**
     * Gets the resource method.
     *
     * @return The resource method
     */
    public Method getResourceMethod() {
        return resourceMethod;
    }

    /**
     * Sets the resource method.
     *
     * @param resourceMethod The resource method
     */
    public void setResourceMethod(Method resourceMethod) {
        this.resourceMethod = resourceMethod;
    }

    /**
     * Gets the resource class
     *
     * @return The resource class
     */
    public Class<?> getResourceClass() {
        return resourceClass;
    }

    /**
     * Sets the resource class
     *
     * @param resourceClass The resource class
     */
    public void setResourceClass(Class<?> resourceClass) {
        this.resourceClass = resourceClass;
    }

    /**
     * Gets the result.
     *
     * @return The result
     */
    public Object getResult() {
        return result;
    }

    /**
     * Sets the result.
     *
     * @param result The result
     */
    public void setResult(Object result) {
        this.result = result;
    }

    /**
     * Gets the HTTP status code.
     *
     * @return The HTTP status code
     */
    public HttpStatusCode getStatus() {
        return status;
    }

    /**
     * Sets the HTTP status code.
     *
     * @param status The HTTP status code
     */
    public void setStatus(HttpStatusCode status) {
        this.status = status;
    }

    /**
     * Gets the invocation start date
     *
     * @return The invocation start date
     */
    public Date getInvocationStart() {
        return invocationStart;
    }

    /**
     * Sets the invocation start date
     *
     * @param invocationStart The invocation start date
     */
    public void setInvocationStart(Date invocationStart) {
        this.invocationStart = invocationStart;
    }

    /**
     * Gets the invocation end date
     *
     * @return The invocation end date
     */
    public Date getInvocationEnd() {
        return invocationEnd;
    }

    /**
     * Sets the invocation end date
     *
     * @param invocationEnd The invocation end date
     */
    public void setInvocationEnd(Date invocationEnd) {
        this.invocationEnd = invocationEnd;
    }
}
