/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.controller;

import net.craftforge.essential.controller.constants.HttpStatusCode;

import java.io.OutputStream;
import java.util.Map;

/**
 * @author Christian Bick
 * @since 20.02.2011
 */
public interface Response {

    /**
     * Sends the response headers and sets the HTTP response status.
     * Must be called prior to <code>getBodyStream();</code>
     *
     * @param status The response status
     * @param headers The response headers
     */
    public void sendHeaders(HttpStatusCode status, Map<String, String[]> headers);

    /**
     * Gets the HTTP status code of this response.
     *
     * @return The HTTP status code
     */
    public HttpStatusCode getStatusCode();

    /**
     * Gets the HTTP headers of this response.
     *
     * @return The HTTP headers
     */
    public Map<String, String[]> getHeaders();

    /**
     * Gets the output stream for streaming the response body.
     *
     * @return The body output stream
     */
    public OutputStream getBodyOutputStream();

}
