/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.controller;

import java.io.InputStream;
import java.util.Map;

/**
 * A controller request normalizes the data from an arbitrary input and provides a
 * standard way of how a controller access the data provided by different contexts.
 *
 * @author Christian Bick
 * @since 19.02.2011
 */
public interface Request {

    /**
     * Gets the HTTP method of the request.
     *
     * @return The HTTP method of the request
     */
    public String getHttpMethod();

    /**
     * Gets the info part of the request url. This is the part being
     * responsible for allocating resources within the framework.
     *
     * @return The info part of the request url
     */
    public String getUrlInfoPart();

    /**
     * Gets the input stream of the request body.
     *
     * @return The input stream of the request body.
     */
    public InputStream getBodyInputStream();

    /**
     * Gets the parameter map, containing all query or form
     * parameters being delivered in the request.
     *
     * @return The parameter map
     */
    public Map<String, String[]> getParameters();

    /**
     * Gets the headers of the request.
     *
     * @return The headers as a map (keys = header names, values = header contents)
     */
    public Map<String, String[]> getHeaders();

}
