/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.controller;

import net.craftforge.essential.controller.constants.HttpStatusCode;

/**
 * Specifies exceptions occurring in the controller.
 *
 * @author Christian Bick
 * @since 02.12.2010
 */
public class ControllerException extends Exception  {

	private static final long serialVersionUID = 13370512820002L;

    private HttpStatusCode httpStatusCode = HttpStatusCode.InternalServerError;

    public ControllerException(String message) {
        super(message);
    }

    public ControllerException(HttpStatusCode httpStatusCode) {
        super(httpStatusCode.getName());
        this.httpStatusCode = httpStatusCode;
    }

    public ControllerException(Throwable t) {
        super(t);
    }

    public ControllerException(String message, HttpStatusCode httpStatusCode) {
        super(message);
        this.httpStatusCode = httpStatusCode;
    }

    public ControllerException(String message, Throwable t) {
        super(message, t);
    }

    public ControllerException(Throwable t, HttpStatusCode httpStatusCode) {
        super(httpStatusCode.getName(), t);
        this.httpStatusCode = httpStatusCode;
    }

    public ControllerException(String message, Throwable t, HttpStatusCode httpStatusCode) {
        super(message, t);
        this.httpStatusCode = httpStatusCode;
    }

    public HttpStatusCode getHttpStatusCode() {
        return httpStatusCode;
    }
}
