/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.context.basic;

import net.craftforge.commons.collections.CaseInsensitiveMap;
import net.craftforge.essential.controller.Request;

import java.io.InputStream;
import java.util.Map;

/**
 * A basic implementation of a controller request.
 *
 * @author Christian Bick
 * @since 20.06.11
 */
public class BasicRequestImpl implements Request {

    private String httpMethod;
    private String urlInfoPart;
    private Map<String, String[]> requestHeaders;
    private Map<String, String[]> requestParameters;
    private InputStream inputStream;

    /**
     * Creates a basic request.
     *
     * @param httpMethod The HTTP request method
     * @param urlInfoPart The request URL info part
     * @param requestHeaders The HTTP request headers
     * @param requestParameters The HTTP request parameters
     * @param inputStream The HTTP body input stream
     */
    public BasicRequestImpl(
            String httpMethod,
            String urlInfoPart,
            Map<String, String[]> requestHeaders,
            Map<String, String[]> requestParameters,
            InputStream inputStream) {

        this.httpMethod = httpMethod;
        this.urlInfoPart = urlInfoPart;
        this.requestHeaders = new CaseInsensitiveMap<String[]>();
        this.requestHeaders.putAll(requestHeaders);
        this.requestParameters = requestParameters;
        this.inputStream = inputStream;
    }

    /**
     * {@inheritDoc}
     */
    public String getHttpMethod() {
        return httpMethod;
    }

    /**
     * {@inheritDoc}
     */
    public String getUrlInfoPart() {
        return urlInfoPart;
    }

    /**
     * {@inheritDoc}
     */
    public Map<String, String[]> getHeaders() {
        return requestHeaders;
    }

    /**
     * {@inheritDoc}
     */
    public Map<String, String[]> getParameters() {
        return requestParameters;
    }

    /**
     * {@inheritDoc}
     */
    public InputStream getBodyInputStream() {
        return inputStream;
    }
}
