/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.commons.collections;

import java.util.HashMap;

/**
 * A map for case-insensitive <code>String</code> keys.
 *
 * @author Christian Bick
 * @since 07.07.11
 */
public class CaseInsensitiveMap<V> extends HashMap<String, V> {

    /**
     * {@inheritDoc}
     * <p>
     * The key is case-insensitive.
     * </p>
     */
    @Override
    public V put(String key, V value) {
        return super.put(key.toLowerCase(), value);
    }

    /**
     * {@inheritDoc}
     * <p>
     * The key is case-insensitive.
     * </p>
     */
    @Override
    public V get(Object key) {
        return super.get(((String)key).toLowerCase());
    }

    /**
     * {@inheritDoc}
     * <p>
     * The key is case-insensitive.
     * </p>
     */
    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(((String)key).toLowerCase());
    }


}
