/*
 * Decompiled with CFR 0.152.
 */
package net.corda.contracts.clause;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.AuthenticatedObject;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.IssueCommand;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.Requirements;
import net.corda.core.contracts.TransactionForContract;
import net.corda.core.contracts.clauses.Clause;
import net.corda.core.crypto.AnonymousParty;
import net.corda.core.crypto.CompositeKey;
import net.corda.core.crypto.Party;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\b0\u0007Bg\u0012)\u0010\t\u001a%\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\b0\f0\n\u00a2\u0006\u0002\b\r\u00125\u0010\u000e\u001a1\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\b0\f0\u000f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\u0010\u0010JV\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u001c0\u000b2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0002\u0018\u00010\bH\u0016R4\u0010\t\u001a%\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\b0\f0\n\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R@\u0010\u000e\u001a1\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\b0\f0\u000f\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lnet/corda/contracts/clause/AbstractIssue;", "S", "Lnet/corda/core/contracts/ContractState;", "C", "Lnet/corda/core/contracts/CommandData;", "T", "", "Lnet/corda/core/contracts/clauses/Clause;", "Lnet/corda/core/contracts/Issued;", "sum", "Lkotlin/Function1;", "", "Lnet/corda/core/contracts/Amount;", "Lkotlin/ExtensionFunctionType;", "sumOrZero", "Lkotlin/Function2;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "getSum", "()Lkotlin/jvm/functions/Function1;", "getSumOrZero", "()Lkotlin/jvm/functions/Function2;", "verify", "", "tx", "Lnet/corda/core/contracts/TransactionForContract;", "inputs", "outputs", "commands", "Lnet/corda/core/contracts/AuthenticatedObject;", "groupingKey", "finance_main"})
public abstract class AbstractIssue<S extends ContractState, C extends CommandData, T>
extends Clause<S, C, Issued<? extends T>> {
    @NotNull
    private final Function1<List<? extends S>, Amount<Issued<T>>> sum;
    @NotNull
    private final Function2<List<? extends S>, Issued<? extends T>, Amount<Issued<T>>> sumOrZero;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<C> verify(@NotNull TransactionForContract tx, @NotNull List<? extends S> inputs, @NotNull List<? extends S> outputs, @NotNull List<? extends AuthenticatedObject<? extends C>> commands, @Nullable Issued<? extends T> groupingKey) {
        String $receiver$iv;
        boolean expr$iv;
        void $receiver;
        Iterable $receiver$iv$iv$iv;
        AuthenticatedObject $receiver$iv$iv;
        Party party$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
        Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
        boolean bl = groupingKey != null;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Collection collection = commands;
        try {
            Collection destination$iv$iv$iv$iv;
            AuthenticatedObject it$iv$iv;
            Iterable $receiver$iv$iv$iv$iv;
            CompositeKey signer$iv$iv;
            void $receiver$iv2;
            void var8_10 = $receiver$iv2;
            Object var9_11 = null;
            Object var10_13 = null;
            int n = 3;
            Iterable iterable = null;
            if (iterable != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: select");
            }
            if ((n & 1) != 0) {
                signer$iv$iv = null;
            }
            if ((n & 2) != 0) {
                party$iv$iv = null;
            }
            iterable = (Iterable)$receiver$iv$iv;
            void var13_17 = $receiver$iv$iv$iv;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                if (!(it$iv$iv.getValue() instanceof IssueCommand)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                if (!(signer$iv$iv == null ? true : it$iv$iv.getSigners().contains(signer$iv$iv))) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                if (!(party$iv$iv == null ? true : it$iv$iv.getSigningParties().contains(party$iv$iv))) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv$iv, (int)10));
            for (Object item$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                it$iv$iv = (AuthenticatedObject)item$iv$iv$iv$iv;
                Collection collection3 = destination$iv$iv$iv$iv;
                Object object = it$iv$iv.getValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.corda.core.contracts.IssueCommand");
                }
                AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv$iv.getSigners(), it$iv$iv.getSigningParties(), (Object)((IssueCommand)object));
                collection3.add(authenticatedObject);
            }
            $receiver$iv$iv = (AuthenticatedObject)CollectionsKt.single((List)((List)destination$iv$iv$iv$iv));
        }
        catch (NoSuchElementException e$iv) {
            throw (Throwable)new IllegalStateException("Required " + Reflection.getOrCreateKotlinClass(IssueCommand.class).getQualifiedName() + " command");
        }
        AuthenticatedObject issueCommand = $receiver$iv$iv;
        Issued<? extends T> issued = groupingKey;
        if (issued == null) {
            Intrinsics.throwNpe();
        }
        AnonymousParty issuer = issued.getIssuer().getParty();
        Amount inputAmount = (Amount)this.sumOrZero.invoke(inputs, groupingKey);
        Amount outputAmount = (Amount)this.sum.invoke(outputs);
        party$iv$iv = Requirements.INSTANCE;
        String $i$f$select = "the issue command has a nonce";
        $receiver$iv$iv$iv = $receiver;
        boolean $receiver$iv$iv$iv$iv = ((IssueCommand)issueCommand.getValue()).getNonce() != 0L;
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
        }
        $receiver$iv = "output states are issued by a command signer";
        void this_$iv = $receiver;
        expr$iv = issueCommand.getSigners().contains(issuer.getOwningKey());
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
        }
        $receiver$iv = "output values sum to more than the inputs";
        this_$iv = $receiver;
        expr$iv = outputAmount.compareTo(inputAmount) > 0;
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
        }
        Object object = issueCommand.getValue();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type C");
        }
        return SetsKt.setOf((Object)((CommandData)object));
    }

    @NotNull
    public final Function1<List<? extends S>, Amount<Issued<T>>> getSum() {
        return this.sum;
    }

    @NotNull
    public final Function2<List<? extends S>, Issued<? extends T>, Amount<Issued<T>>> getSumOrZero() {
        return this.sumOrZero;
    }

    public AbstractIssue(@NotNull Function1<? super List<? extends S>, Amount<Issued<T>>> sum, @NotNull Function2<? super List<? extends S>, ? super Issued<? extends T>, Amount<Issued<T>>> sumOrZero) {
        Intrinsics.checkParameterIsNotNull(sum, (String)"sum");
        Intrinsics.checkParameterIsNotNull(sumOrZero, (String)"sumOrZero");
        this.sum = sum;
        this.sumOrZero = sumOrZero;
    }
}

