/*
 * Decompiled with CFR 0.152.
 */
package net.corda.contracts.asset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.contracts.asset.CashKt;
import net.corda.contracts.asset.OnLedgerAsset;
import net.corda.contracts.clause.AbstractConserveAmount;
import net.corda.contracts.clause.AbstractIssue;
import net.corda.contracts.clause.NoZeroSizedOutputs;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.AuthenticatedObject;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.FungibleAsset;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.TransactionForContract;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.clauses.AllOf;
import net.corda.core.contracts.clauses.Clause;
import net.corda.core.contracts.clauses.ClauseVerifier;
import net.corda.core.contracts.clauses.FirstOf;
import net.corda.core.contracts.clauses.GroupClauseVerifier;
import net.corda.core.crypto.CompositeKey;
import net.corda.core.crypto.CryptoUtilities;
import net.corda.core.crypto.Party;
import net.corda.core.crypto.SecureHash;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.schemas.PersistentState;
import net.corda.core.schemas.QueryableState;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.Emoji;
import net.corda.schemas.CashSchemaV1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0003-./B\u0005\u00a2\u0006\u0002\u0010\u0005J8\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00180\u00172\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00180\u001aH\u0016J\u001c\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00130\u0012H\u0016J2\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#J4\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020,H\u0016R&\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u00060"}, d2={"Lnet/corda/contracts/asset/Cash;", "Lnet/corda/contracts/asset/OnLedgerAsset;", "Ljava/util/Currency;", "Lnet/corda/contracts/asset/Cash$Commands;", "Lnet/corda/contracts/asset/Cash$State;", "()V", "conserveClause", "Lnet/corda/contracts/clause/AbstractConserveAmount;", "getConserveClause", "()Lnet/corda/contracts/clause/AbstractConserveAmount;", "legalContractReference", "Lnet/corda/core/crypto/SecureHash;", "getLegalContractReference", "()Lnet/corda/core/crypto/SecureHash;", "deriveState", "Lnet/corda/core/contracts/TransactionState;", "txState", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "owner", "Lnet/corda/core/crypto/CompositeKey;", "extractCommands", "", "Lnet/corda/core/contracts/AuthenticatedObject;", "commands", "", "Lnet/corda/core/contracts/CommandData;", "generateExitCommand", "Lnet/corda/contracts/asset/Cash$Commands$Exit;", "generateIssue", "", "tx", "Lnet/corda/core/transactions/TransactionBuilder;", "notary", "Lnet/corda/core/crypto/Party;", "tokenDef", "pennies", "", "generateIssueCommand", "Lnet/corda/contracts/asset/Cash$Commands$Issue;", "generateMoveCommand", "Lnet/corda/contracts/asset/Cash$Commands$Move;", "verify", "Lnet/corda/core/contracts/TransactionForContract;", "Clauses", "Commands", "State", "finance_main"})
public final class Cash
extends OnLedgerAsset<Currency, Commands, State> {
    @NotNull
    private final SecureHash legalContractReference = (SecureHash)SecureHash.Companion.sha256("https://www.big-book-of-banking-law.gov/cash-claims.html");
    @NotNull
    private final AbstractConserveAmount<State, Commands, Currency> conserveClause = new Clauses.ConserveAmount();

    @NotNull
    public SecureHash getLegalContractReference() {
        return this.legalContractReference;
    }

    @Override
    @NotNull
    public AbstractConserveAmount<State, Commands, Currency> getConserveClause() {
        return this.conserveClause;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AuthenticatedObject<Commands>> extractCommands(@NotNull Collection<? extends AuthenticatedObject<? extends CommandData>> commands) {
        Collection destination$iv$iv$iv;
        AuthenticatedObject it$iv;
        Iterable $receiver$iv$iv$iv;
        Iterable $receiver$iv$iv;
        void $receiver$iv;
        Party party$iv;
        CompositeKey signer$iv;
        Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
        Collection<? extends AuthenticatedObject<? extends CommandData>> collection = commands;
        Object var3_3 = null;
        Object var4_4 = null;
        int n = 3;
        Iterable iterable = null;
        if (iterable != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: select");
        }
        if ((n & 1) != 0) {
            signer$iv = null;
        }
        if ((n & 2) != 0) {
            party$iv = null;
        }
        iterable = (Iterable)$receiver$iv;
        void var7_7 = $receiver$iv$iv;
        Collection collection2 = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)element$iv$iv$iv;
            if (!(it$iv.getValue() instanceof Commands)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv$iv = $receiver$iv$iv;
        destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)element$iv$iv$iv;
            if (!(signer$iv == null ? true : it$iv.getSigners().contains(signer$iv))) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv$iv = $receiver$iv$iv;
        destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)element$iv$iv$iv;
            if (!(party$iv == null ? true : it$iv.getSigningParties().contains(party$iv))) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv$iv = $receiver$iv$iv;
        destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv, (int)10));
        for (Object item$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)item$iv$iv$iv;
            Collection collection3 = destination$iv$iv$iv;
            Object object = it$iv.getValue();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.contracts.asset.Cash.Commands");
            }
            AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv.getSigners(), it$iv.getSigningParties(), (Object)((Commands)object));
            collection3.add(authenticatedObject);
        }
        return (List)destination$iv$iv$iv;
    }

    public final void generateIssue(@NotNull TransactionBuilder tx, @NotNull Issued<Currency> tokenDef, long pennies, @NotNull CompositeKey owner, @NotNull Party notary) {
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(tokenDef, (String)"tokenDef");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
        this.generateIssue(tx, (Amount<Issued<Currency>>)new Amount(pennies, tokenDef), owner, notary);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateIssue(@NotNull TransactionBuilder tx, @NotNull Amount<Issued<Currency>> amount, @NotNull CompositeKey owner, @NotNull Party notary) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv22;
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
        boolean bl = tx.inputStates().isEmpty();
        if (!bl) {
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Iterable iterable = tx.outputStates();
        String string = $receiver$iv22;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv22, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TransactionState transactionState = (TransactionState)item$iv$iv;
            void var14_15 = destination$iv$iv;
            ContractState contractState = it.getData();
            var14_15.add(contractState);
        }
        boolean $receiver$iv22 = CashKt.sumCashOrNull((List)destination$iv$iv) == null;
        if (!$receiver$iv22) {
            string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        PartyAndReference at = ((Issued)amount.getToken()).getIssuer();
        tx.addOutputState(new TransactionState((ContractState)new State(amount, owner), notary, null, 4, null));
        tx.addCommand((CommandData)this.generateIssueCommand(), new CompositeKey[]{at.getParty().getOwningKey()});
    }

    @Override
    @NotNull
    public TransactionState<State> deriveState(@NotNull TransactionState<State> txState, @NotNull Amount<Issued<Currency>> amount, @NotNull CompositeKey owner) {
        Intrinsics.checkParameterIsNotNull(txState, (String)"txState");
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        return TransactionState.copy$default(txState, (ContractState)((ContractState)((State)txState.getData()).copy(amount, owner)), null, null, (int)6, null);
    }

    @NotNull
    public Commands.Exit generateExitCommand(@NotNull Amount<Issued<Currency>> amount) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        return new Commands.Exit(amount);
    }

    @Override
    @NotNull
    public Commands.Issue generateIssueCommand() {
        return new Commands.Issue(0L, 1, null);
    }

    @Override
    @NotNull
    public Commands.Move generateMoveCommand() {
        return new Commands.Move(null, 1, null);
    }

    public void verify(@NotNull TransactionForContract tx) {
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        ClauseVerifier.verifyClause((TransactionForContract)tx, (Clause)((Clause)new Clauses.Group()), (List)this.extractCommands((Collection)tx.getCommands()));
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/contracts/asset/Cash$Clauses;", "", "ConserveAmount", "Group", "Issue", "finance_main"})
    public static interface Clauses {

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lnet/corda/contracts/asset/Cash$Clauses$Group;", "Lnet/corda/core/contracts/clauses/GroupClauseVerifier;", "Lnet/corda/contracts/asset/Cash$State;", "Lnet/corda/contracts/asset/Cash$Commands;", "Lnet/corda/core/contracts/Issued;", "Ljava/util/Currency;", "()V", "groupStates", "", "Lnet/corda/core/contracts/TransactionForContract$InOutGroup;", "tx", "Lnet/corda/core/contracts/TransactionForContract;", "finance_main"})
        public static final class Group
        extends GroupClauseVerifier<State, Commands, Issued<? extends Currency>> {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<TransactionForContract.InOutGroup<State, Issued<Currency>>> groupStates(@NotNull TransactionForContract tx) {
                void destination$iv$iv$iv;
                void $receiver$iv$iv$iv;
                void $receiver$iv$iv;
                Object value$iv$iv$iv$iv;
                void destination$iv$iv$iv2;
                State it;
                Iterable $receiver$iv$iv$iv2;
                void $receiver$iv$iv2;
                void destination$iv$iv$iv3;
                Object element$iv$iv$iv3;
                Iterable $receiver$iv$iv$iv3;
                void $receiver$iv$iv3;
                void destination$iv$iv$iv4;
                Object element$iv$iv$iv22;
                Iterable $receiver$iv$iv$iv4;
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                TransactionForContract this_$iv = tx;
                Iterable $receiver$iv$iv4 = this_$iv.getInputs();
                Iterable iterable = $receiver$iv$iv4;
                Collection collection = new ArrayList();
                for (Object element$iv$iv$iv22 : $receiver$iv$iv$iv4) {
                    if (!(element$iv$iv$iv22 instanceof State)) continue;
                    destination$iv$iv$iv4.add(element$iv$iv$iv22);
                }
                List inputs$iv = (List)destination$iv$iv$iv4;
                $receiver$iv$iv$iv4 = this_$iv.getOutputs();
                destination$iv$iv$iv4 = $receiver$iv$iv3;
                Collection collection2 = new ArrayList();
                for (Object element$iv$iv$iv3 : $receiver$iv$iv$iv3) {
                    if (!(element$iv$iv$iv3 instanceof State)) continue;
                    destination$iv$iv$iv3.add(element$iv$iv$iv3);
                }
                List outputs$iv = (List)destination$iv$iv$iv3;
                $receiver$iv$iv$iv3 = inputs$iv;
                destination$iv$iv$iv3 = $receiver$iv$iv2;
                element$iv$iv$iv22 = new LinkedHashMap();
                for (Object element$iv$iv$iv4 : $receiver$iv$iv$iv2) {
                    Object object;
                    void $receiver$iv$iv$iv$iv;
                    it = (State)element$iv$iv$iv4;
                    Issued key$iv$iv$iv = (Issued)it.getAmount().getToken();
                    void var14_13 = destination$iv$iv$iv2;
                    value$iv$iv$iv$iv = $receiver$iv$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv$iv == null) {
                        ArrayList answer$iv$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv$iv);
                        object = answer$iv$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv$iv;
                    }
                    List list$iv$iv$iv = (List)object;
                    list$iv$iv$iv.add(element$iv$iv$iv4);
                }
                void inGroups$iv = destination$iv$iv$iv2;
                $receiver$iv$iv$iv2 = outputs$iv;
                destination$iv$iv$iv2 = $receiver$iv$iv;
                element$iv$iv$iv3 = new LinkedHashMap();
                for (Object element$iv$iv$iv5 : $receiver$iv$iv$iv) {
                    Object object;
                    void $receiver$iv$iv$iv$iv;
                    it = (State)element$iv$iv$iv5;
                    Issued key$iv$iv$iv = (Issued)it.getAmount().getToken();
                    value$iv$iv$iv$iv = destination$iv$iv$iv;
                    Object value$iv$iv$iv$iv2 = $receiver$iv$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv$iv2 == null) {
                        ArrayList answer$iv$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv$iv);
                        object = answer$iv$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv$iv2;
                    }
                    List list$iv$iv$iv = (List)object;
                    list$iv$iv$iv.add(element$iv$iv$iv5);
                }
                void outGroups$iv = destination$iv$iv$iv;
                return this_$iv.groupStatesInternal((Map)inGroups$iv, (Map)outGroups$iv);
            }

            public Group() {
                super((Clause)new AllOf((Clause)new NoZeroSizedOutputs(), new Clause[]{(Clause)new FirstOf((Clause)new Issue(), new Clause[]{new ConserveAmount()})}));
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005R\"\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/corda/contracts/asset/Cash$Clauses$Issue;", "Lnet/corda/contracts/clause/AbstractIssue;", "Lnet/corda/contracts/asset/Cash$State;", "Lnet/corda/contracts/asset/Cash$Commands;", "Ljava/util/Currency;", "()V", "requiredCommands", "", "Ljava/lang/Class;", "Lnet/corda/core/contracts/CommandData;", "getRequiredCommands", "()Ljava/util/Set;", "finance_main"})
        public static final class Issue
        extends AbstractIssue<State, Commands, Currency> {
            @NotNull
            private final Set<Class<? extends CommandData>> requiredCommands = SetsKt.setOf(Commands.Issue.class);

            @NotNull
            public Set<Class<? extends CommandData>> getRequiredCommands() {
                return this.requiredCommands;
            }

            public Issue() {
                super(1.INSTANCE, 2.INSTANCE);
            }
        }

        @CordaSerializable
        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/contracts/asset/Cash$Clauses$ConserveAmount;", "Lnet/corda/contracts/clause/AbstractConserveAmount;", "Lnet/corda/contracts/asset/Cash$State;", "Lnet/corda/contracts/asset/Cash$Commands;", "Ljava/util/Currency;", "()V", "finance_main"})
        public static final class ConserveAmount
        extends AbstractConserveAmount<State, Commands, Currency> {
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B%\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB!\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J)\u0010\u001f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J*\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\u00072\u0006\u0010&\u001a\u00020\tH\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020#0(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u00000,2\u0006\u0010&\u001a\u00020\tH\u0016R \u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006."}, d2={"Lnet/corda/contracts/asset/Cash$State;", "Lnet/corda/core/contracts/FungibleAsset;", "Ljava/util/Currency;", "Lnet/corda/core/schemas/QueryableState;", "deposit", "Lnet/corda/core/contracts/PartyAndReference;", "amount", "Lnet/corda/core/contracts/Amount;", "owner", "Lnet/corda/core/crypto/CompositeKey;", "(Lnet/corda/core/contracts/PartyAndReference;Lnet/corda/core/contracts/Amount;Lnet/corda/core/crypto/CompositeKey;)V", "Lnet/corda/core/contracts/Issued;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/crypto/CompositeKey;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "contract", "Lnet/corda/contracts/asset/Cash;", "getContract", "()Lnet/corda/contracts/asset/Cash;", "exitKeys", "", "getExitKeys", "()Ljava/util/Set;", "getOwner", "()Lnet/corda/core/crypto/CompositeKey;", "participants", "", "getParticipants", "()Ljava/util/List;", "component1", "component2", "copy", "generateMappedObject", "Lnet/corda/core/schemas/PersistentState;", "schema", "Lnet/corda/core/schemas/MappedSchema;", "move", "newAmount", "newOwner", "supportedSchemas", "", "toString", "", "withNewOwner", "Lkotlin/Pair;", "Lnet/corda/contracts/asset/Cash$Commands$Move;", "finance_main"})
    public static final class State
    implements FungibleAsset<Currency>,
    QueryableState {
        @NotNull
        private final Set<CompositeKey> exitKeys;
        @NotNull
        private final Cash contract;
        @NotNull
        private final List<CompositeKey> participants;
        @NotNull
        private final Amount<Issued<Currency>> amount;
        @NotNull
        private final CompositeKey owner;

        @NotNull
        public Set<CompositeKey> getExitKeys() {
            return this.exitKeys;
        }

        @NotNull
        public Cash getContract() {
            return this.contract;
        }

        @NotNull
        public List<CompositeKey> getParticipants() {
            return this.participants;
        }

        @NotNull
        public FungibleAsset<Currency> move(@NotNull Amount<Issued<Currency>> newAmount, @NotNull CompositeKey newOwner) {
            Intrinsics.checkParameterIsNotNull(newAmount, (String)"newAmount");
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return this.copy((Amount<Issued<Currency>>)this.getAmount().copy(newAmount.getQuantity(), this.getAmount().getToken()), newOwner);
        }

        @NotNull
        public String toString() {
            return Emoji.INSTANCE.getBagOfCash() + "Cash(" + this.getAmount() + " at " + ((Issued)this.getAmount().getToken()).getIssuer() + " owned by " + this.getOwner() + ")";
        }

        @NotNull
        public Pair<Commands.Move, State> withNewOwner(@NotNull CompositeKey newOwner) {
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return new Pair((Object)new Commands.Move(null, 1, null), (Object)State.copy$default(this, null, newOwner, 1, null));
        }

        @NotNull
        public PersistentState generateMappedObject(@NotNull MappedSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            MappedSchema mappedSchema = schema;
            if (!(mappedSchema instanceof CashSchemaV1)) {
                throw (Throwable)new IllegalArgumentException("Unrecognised schema " + schema);
            }
            String string = this.getOwner().toBase58String();
            long l = this.getAmount().getQuantity();
            String string2 = ((Currency)((Issued)this.getAmount().getToken()).getProduct()).getCurrencyCode();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"this.amount.token.product.currencyCode");
            return new CashSchemaV1.PersistentCashState(string, l, string2, ((Issued)this.getAmount().getToken()).getIssuer().getParty().getOwningKey().toBase58String(), ((Issued)this.getAmount().getToken()).getIssuer().getReference().getBytes());
        }

        @NotNull
        public Iterable<MappedSchema> supportedSchemas() {
            return CollectionsKt.listOf((Object)((Object)CashSchemaV1.INSTANCE));
        }

        @NotNull
        public Amount<Issued<Currency>> getAmount() {
            return this.amount;
        }

        @NotNull
        public CompositeKey getOwner() {
            return this.owner;
        }

        public State(@NotNull Amount<Issued<Currency>> amount, @NotNull CompositeKey owner) {
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            this.amount = amount;
            this.owner = owner;
            this.exitKeys = SetsKt.setOf((Object[])new CompositeKey[]{this.getOwner(), ((Issued)this.getAmount().getToken()).getIssuer().getParty().getOwningKey()});
            this.contract = CashKt.getCASH_PROGRAM_ID();
            this.participants = CollectionsKt.listOf((Object)this.getOwner());
        }

        public State(@NotNull PartyAndReference deposit, @NotNull Amount<Currency> amount, @NotNull CompositeKey owner) {
            Intrinsics.checkParameterIsNotNull((Object)deposit, (String)"deposit");
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            this((Amount<Issued<Currency>>)new Amount(amount.getQuantity(), (Object)new Issued(deposit, amount.getToken())), owner);
        }

        @NotNull
        public final Amount<Issued<Currency>> component1() {
            return this.getAmount();
        }

        @NotNull
        public final CompositeKey component2() {
            return this.getOwner();
        }

        @NotNull
        public final State copy(@NotNull Amount<Issued<Currency>> amount, @NotNull CompositeKey owner) {
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            return new State(amount, owner);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ State copy$default(State state, Amount amount, CompositeKey compositeKey, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                amount = state.getAmount();
            }
            if ((n & 2) != 0) {
                compositeKey = state.getOwner();
            }
            return state.copy(amount, compositeKey);
        }

        public int hashCode() {
            Amount<Issued<Currency>> amount = this.getAmount();
            CompositeKey compositeKey = this.getOwner();
            return (amount != null ? amount.hashCode() : 0) * 31 + (compositeKey != null ? compositeKey.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual(this.getAmount(), state.getAmount()) || !Intrinsics.areEqual((Object)this.getOwner(), (Object)state.getOwner())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/contracts/asset/Cash$Commands;", "Lnet/corda/core/contracts/FungibleAsset$Commands;", "Exit", "Issue", "Move", "finance_main"})
    public static interface Commands
    extends FungibleAsset.Commands {

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lnet/corda/contracts/asset/Cash$Commands$Move;", "Lnet/corda/core/contracts/FungibleAsset$Commands$Move;", "Lnet/corda/contracts/asset/Cash$Commands;", "contractHash", "Lnet/corda/core/crypto/SecureHash;", "(Lnet/corda/core/crypto/SecureHash;)V", "getContractHash", "()Lnet/corda/core/crypto/SecureHash;", "component1", "copy", "finance_main"})
        public static final class Move
        implements FungibleAsset.Commands.Move,
        Commands {
            @Nullable
            private final SecureHash contractHash;

            @Nullable
            public SecureHash getContractHash() {
                return this.contractHash;
            }

            public Move(@Nullable SecureHash contractHash) {
                this.contractHash = contractHash;
            }

            public /* synthetic */ Move(SecureHash secureHash, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    secureHash = null;
                }
                this(secureHash);
            }

            public Move() {
                this(null, 1, null);
            }

            @Nullable
            public final SecureHash component1() {
                return this.getContractHash();
            }

            @NotNull
            public final Move copy(@Nullable SecureHash contractHash) {
                return new Move(contractHash);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Move copy$default(Move move, SecureHash secureHash, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
                }
                if ((n & 1) != 0) {
                    secureHash = move.getContractHash();
                }
                return move.copy(secureHash);
            }

            public String toString() {
                return "Move(contractHash=" + this.getContractHash() + ")";
            }

            public int hashCode() {
                SecureHash secureHash = this.getContractHash();
                return secureHash != null ? secureHash.hashCode() : 0;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Move)) break block3;
                        Move move = (Move)object;
                        if (!Intrinsics.areEqual((Object)this.getContractHash(), (Object)move.getContractHash())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lnet/corda/contracts/asset/Cash$Commands$Issue;", "Lnet/corda/core/contracts/FungibleAsset$Commands$Issue;", "Lnet/corda/contracts/asset/Cash$Commands;", "nonce", "", "(J)V", "getNonce", "()J", "component1", "copy", "finance_main"})
        public static final class Issue
        implements FungibleAsset.Commands.Issue,
        Commands {
            private final long nonce;

            public long getNonce() {
                return this.nonce;
            }

            public Issue(long nonce) {
                this.nonce = nonce;
            }

            public /* synthetic */ Issue(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    l = CryptoUtilities.newSecureRandom().nextLong();
                }
                this(l);
            }

            public Issue() {
                this(0L, 1, null);
            }

            public final long component1() {
                return this.getNonce();
            }

            @NotNull
            public final Issue copy(long nonce) {
                return new Issue(nonce);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Issue copy$default(Issue issue, long l, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
                }
                if ((n & 1) != 0) {
                    l = issue.getNonce();
                }
                return issue.copy(l);
            }

            public String toString() {
                return "Issue(nonce=" + this.getNonce() + ")";
            }

            public int hashCode() {
                long l = this.getNonce();
                return (int)(l ^ l >>> 32);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Issue)) break block3;
                        Issue issue = (Issue)object;
                        if (!(this.getNonce() == issue.getNonce())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u00c6\u0001R \u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lnet/corda/contracts/asset/Cash$Commands$Exit;", "Lnet/corda/contracts/asset/Cash$Commands;", "Lnet/corda/core/contracts/FungibleAsset$Commands$Exit;", "Ljava/util/Currency;", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "(Lnet/corda/core/contracts/Amount;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "component1", "copy", "finance_main"})
        public static final class Exit
        implements Commands,
        FungibleAsset.Commands.Exit<Currency> {
            @NotNull
            private final Amount<Issued<Currency>> amount;

            @NotNull
            public Amount<Issued<Currency>> getAmount() {
                return this.amount;
            }

            public Exit(@NotNull Amount<Issued<Currency>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                this.amount = amount;
            }

            @NotNull
            public final Amount<Issued<Currency>> component1() {
                return this.getAmount();
            }

            @NotNull
            public final Exit copy(@NotNull Amount<Issued<Currency>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                return new Exit(amount);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Exit copy$default(Exit exit, Amount amount, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
                }
                if ((n & 1) != 0) {
                    amount = exit.getAmount();
                }
                return exit.copy(amount);
            }

            public String toString() {
                return "Exit(amount=" + this.getAmount() + ")";
            }

            public int hashCode() {
                Amount<Issued<Currency>> amount = this.getAmount();
                return amount != null ? amount.hashCode() : 0;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Exit)) break block3;
                        Exit exit = (Exit)object;
                        if (!Intrinsics.areEqual(this.getAmount(), exit.getAmount())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

