/*
 * Decompiled with CFR 0.152.
 */
package net.corda.flows;

import co.paralleluniverse.fibers.Suspendable;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Currency;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.InsufficientBalanceException;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.StructuresKt;
import net.corda.core.contracts.TransactionType;
import net.corda.core.crypto.CompositeKeyKt;
import net.corda.core.crypto.CryptoUtilities;
import net.corda.core.crypto.Party;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.ProgressTracker;
import net.corda.flows.AbstractCashFlow;
import net.corda.flows.CashException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0017R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lnet/corda/flows/CashPaymentFlow;", "Lnet/corda/flows/AbstractCashFlow;", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "Ljava/util/Currency;", "recipient", "Lnet/corda/core/crypto/Party;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/crypto/Party;)V", "progressTracker", "Lnet/corda/core/utilities/ProgressTracker;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/crypto/Party;Lnet/corda/core/utilities/ProgressTracker;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "getRecipient", "()Lnet/corda/core/crypto/Party;", "call", "Lnet/corda/core/transactions/SignedTransaction;", "finance_main"})
public class CashPaymentFlow
extends AbstractCashFlow {
    @NotNull
    private final Amount<Issued<Currency>> amount;
    @NotNull
    private final Party recipient;

    /*
     * WARNING - void declaration
     */
    @Suspendable
    @NotNull
    public SignedTransaction call() {
        void spendTX;
        void $receiver$iv;
        void keysForSigning;
        Pair pair;
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.GENERATING_TX.INSTANCE);
        TransactionBuilder builder = (TransactionBuilder)new TransactionType.General.Builder((Party)null);
        try {
            pair = this.getServiceHub().getVaultService().generateSpend(builder, StructuresKt.withoutIssuer(this.amount), this.recipient.getOwningKey(), SetsKt.setOf((Object)((Issued)this.amount.getToken()).getIssuer().getParty()));
        }
        catch (InsufficientBalanceException e) {
            throw (Throwable)((Object)new CashException("Insufficient cash for spend", e));
        }
        Object object = pair;
        TransactionBuilder transactionBuilder = (TransactionBuilder)object.component1();
        List list = (List)object.component2();
        object = null;
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.SIGNING_TX.INSTANCE);
        object = CompositeKeyKt.getKeys((Iterable)((Iterable)keysForSigning));
        for (Object element$iv : $receiver$iv) {
            PrivateKey key;
            PublicKey it = (PublicKey)element$iv;
            if ((PrivateKey)this.getServiceHub().getKeyManagementService().getKeys().get(it) == null) {
                throw (Throwable)new IllegalStateException("Could not find signing key for " + CryptoUtilities.toStringShort((PublicKey)it));
            }
            builder.signWith(new KeyPair(it, key));
        }
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.FINALISING_TX.INSTANCE);
        SignedTransaction tx = spendTX.toSignedTransaction(false);
        this.finaliseTx$finance_main(SetsKt.setOf((Object)this.recipient), tx, "Unable to notarise spend");
        return tx;
    }

    @NotNull
    public final Amount<Issued<Currency>> getAmount() {
        return this.amount;
    }

    @NotNull
    public final Party getRecipient() {
        return this.recipient;
    }

    public CashPaymentFlow(@NotNull Amount<Issued<Currency>> amount, @NotNull Party recipient, @NotNull ProgressTracker progressTracker) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        Intrinsics.checkParameterIsNotNull((Object)progressTracker, (String)"progressTracker");
        super(progressTracker);
        this.amount = amount;
        this.recipient = recipient;
    }

    public CashPaymentFlow(@NotNull Amount<Issued<Currency>> amount, @NotNull Party recipient) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        this(amount, recipient, AbstractCashFlow.Companion.tracker());
    }
}

