/*
 * Decompiled with CFR 0.152.
 */
package net.corda.flows;

import co.paralleluniverse.fibers.Suspendable;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.contracts.asset.Cash;
import net.corda.contracts.asset.OnLedgerAsset;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.ContractsDSL;
import net.corda.core.contracts.InsufficientBalanceException;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.StateRef;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.TransactionType;
import net.corda.core.crypto.Party;
import net.corda.core.node.services.Vault;
import net.corda.core.node.services.VaultService;
import net.corda.core.serialization.OpaqueBytes;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.ProgressTracker;
import net.corda.flows.AbstractCashFlow;
import net.corda.flows.CashException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0017R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lnet/corda/flows/CashExitFlow;", "Lnet/corda/flows/AbstractCashFlow;", "amount", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "issueRef", "Lnet/corda/core/serialization/OpaqueBytes;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/serialization/OpaqueBytes;)V", "progressTracker", "Lnet/corda/core/utilities/ProgressTracker;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/serialization/OpaqueBytes;Lnet/corda/core/utilities/ProgressTracker;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "getIssueRef", "()Lnet/corda/core/serialization/OpaqueBytes;", "call", "Lnet/corda/core/transactions/SignedTransaction;", "Companion", "finance_main"})
public final class CashExitFlow
extends AbstractCashFlow {
    @NotNull
    private final Amount<Currency> amount;
    @NotNull
    private final OpaqueBytes issueRef;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Suspendable
    @NotNull
    public SignedTransaction call() throws CashException {
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable destination$iv$iv2;
        Map $receiver$iv$iv2;
        void $receiver$iv2;
        Object it;
        Object element$iv$iv2;
        Object object;
        TransactionBuilder transactionBuilder;
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.GENERATING_TX.INSTANCE);
        TransactionBuilder builder = (TransactionBuilder)new TransactionType.General.Builder((Party)null);
        PartyAndReference issuer = this.getServiceHub().getMyInfo().getLegalIdentity().ref(this.issueRef);
        try {
            void destination$iv$iv3;
            void $receiver$iv$iv3;
            Iterable $receiver$iv3;
            VaultService vaultService = this.getServiceHub().getVaultService();
            Amount amount = ContractsDSL.issuedBy(this.amount, (PartyAndReference)issuer);
            transactionBuilder = builder;
            object = new Cash();
            Set set = SetsKt.setOf(Cash.State.class);
            EnumSet<Enum> enumSet = EnumSet.of((Enum)Vault.StateStatus.UNCONSUMED);
            Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"EnumSet.of(Vault.StateStatus.UNCONSUMED)");
            List list = $receiver$iv3.states(set, enumSet);
            $receiver$iv3 = list;
            Iterable $i$f$unconsumedStates = $receiver$iv3;
            Collection collection = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv3) {
                it = (StateAndRef)element$iv$iv2;
                if (!Intrinsics.areEqual((Object)((Cash.State)it.getState().getData()).getOwner(), (Object)issuer.getParty().getOwningKey())) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            list = (List)destination$iv$iv3;
            ((OnLedgerAsset)object).generateExit(transactionBuilder, amount, list);
        }
        catch (InsufficientBalanceException e) {
            throw (Throwable)((Object)new CashException("Exiting more cash than exists", e));
        }
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.SIGNING_TX.INSTANCE);
        KeyPair myKey = this.getServiceHub().getLegalIdentityKey();
        builder.signWith(myKey);
        Map inputStatesNullable = this.getServiceHub().getVaultService().statesForRefs(builder.inputStates());
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)inputStatesNullable.values());
        element$iv$iv2 = $receiver$iv2;
        it = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Object $i$a$1$filter = $receiver$iv$iv2.iterator();
        while ($i$a$1$filter.hasNext()) {
            Iterator it2;
            Object item$iv$iv = $i$a$1$filter.next();
            TransactionState $i$f$filter = (TransactionState)item$iv$iv;
            object = destination$iv$iv2;
            transactionBuilder = it2.getData();
            object.add(transactionBuilder);
        }
        List inputStates = (List)destination$iv$iv2;
        if (inputStatesNullable.size() != inputStates.size()) {
            Map.Entry it3;
            $receiver$iv$iv2 = inputStatesNullable;
            destination$iv$iv2 = $receiver$iv;
            $i$a$1$filter = new LinkedHashMap();
            Iterator iterator = $receiver$iv$iv;
            for (Map.Entry element$iv$iv3 : iterator.entrySet()) {
                it3 = element$iv$iv3;
                if (!(it3.getValue() == null)) continue;
                destination$iv$iv.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
            }
            $receiver$iv = destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList($receiver$iv.size());
            iterator = $receiver$iv$iv;
            for (Map.Entry item$iv$iv : iterator.entrySet()) {
                it3 = item$iv$iv;
                object = destination$iv$iv;
                transactionBuilder = (StateRef)it3.getKey();
                object.add(transactionBuilder);
            }
            List unresolvedStateRefs = (List)destination$iv$iv;
            throw (Throwable)new IllegalStateException("Failed to resolve input StateRefs: " + unresolvedStateRefs);
        }
        $receiver$iv = inputStates;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv4 : $receiver$iv$iv) {
            if (!(element$iv$iv4 instanceof Cash.State)) continue;
            destination$iv$iv.add(element$iv$iv4);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it4;
            Cash.State $i$f$filterIsInstanceTo = (Cash.State)item$iv$iv;
            object = destination$iv$iv;
            transactionBuilder = this.getServiceHub().getIdentityService().partyFromKey(it4.getOwner());
            object.add(transactionBuilder);
        }
        Set participants = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        SignedTransaction tx = builder.toSignedTransaction(false);
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)AbstractCashFlow.Companion.FINALISING_TX.INSTANCE);
        this.finaliseTx$finance_main(participants, tx, "Unable to notarise exit");
        return tx;
    }

    @NotNull
    public final Amount<Currency> getAmount() {
        return this.amount;
    }

    @NotNull
    public final OpaqueBytes getIssueRef() {
        return this.issueRef;
    }

    public CashExitFlow(@NotNull Amount<Currency> amount, @NotNull OpaqueBytes issueRef, @NotNull ProgressTracker progressTracker) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)issueRef, (String)"issueRef");
        Intrinsics.checkParameterIsNotNull((Object)progressTracker, (String)"progressTracker");
        super(progressTracker);
        this.amount = amount;
        this.issueRef = issueRef;
    }

    public CashExitFlow(@NotNull Amount<Currency> amount, @NotNull OpaqueBytes issueRef) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)issueRef, (String)"issueRef");
        this(amount, issueRef, Companion.tracker());
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/flows/CashExitFlow$Companion;", "", "()V", "tracker", "Lnet/corda/core/utilities/ProgressTracker;", "finance_main"})
    public static final class Companion {
        @NotNull
        public final ProgressTracker tracker() {
            return new ProgressTracker(new ProgressTracker.Step[]{AbstractCashFlow.Companion.GENERATING_TX.INSTANCE, AbstractCashFlow.Companion.SIGNING_TX.INSTANCE, AbstractCashFlow.Companion.FINALISING_TX.INSTANCE});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

