/*
 * Decompiled with CFR 0.152.
 */
package net.corda.flows;

import co.paralleluniverse.fibers.Suspendable;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.contracts.asset.Cash;
import net.corda.contracts.asset.OnLedgerAsset;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.ContractsDSL;
import net.corda.core.contracts.InsufficientBalanceException;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.StateRef;
import net.corda.core.contracts.StructuresKt;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.TransactionType;
import net.corda.core.crypto.CompositeKeyKt;
import net.corda.core.crypto.CryptoUtilities;
import net.corda.core.crypto.Party;
import net.corda.core.flows.FlowLogic;
import net.corda.core.node.services.Vault;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.ProgressTracker;
import net.corda.flows.BroadcastTransactionFlow;
import net.corda.flows.CashCommand;
import net.corda.flows.CashException;
import net.corda.flows.FinalityFlow;
import net.corda.flows.NotaryException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u0002H\u0017J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J&\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0003J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u001aH\u0003J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u001cH\u0003R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lnet/corda/flows/CashFlow;", "Lnet/corda/core/flows/FlowLogic;", "Lnet/corda/core/transactions/SignedTransaction;", "command", "Lnet/corda/flows/CashCommand;", "(Lnet/corda/flows/CashCommand;)V", "progressTracker", "Lnet/corda/core/utilities/ProgressTracker;", "(Lnet/corda/flows/CashCommand;Lnet/corda/core/utilities/ProgressTracker;)V", "getCommand", "()Lnet/corda/flows/CashCommand;", "getProgressTracker", "()Lnet/corda/core/utilities/ProgressTracker;", "call", "exitCash", "req", "Lnet/corda/flows/CashCommand$ExitCash;", "finaliseTx", "", "participants", "", "Lnet/corda/core/crypto/Party;", "tx", "message", "", "initiatePayment", "Lnet/corda/flows/CashCommand$PayCash;", "issueCash", "Lnet/corda/flows/CashCommand$IssueCash;", "Companion", "finance_main"})
public final class CashFlow
extends FlowLogic<SignedTransaction> {
    @NotNull
    private final CashCommand command;
    @NotNull
    private final ProgressTracker progressTracker;
    public static final Companion Companion = new Companion(null);

    @Suspendable
    @NotNull
    public SignedTransaction call() throws CashException {
        SignedTransaction signedTransaction;
        CashCommand cashCommand = this.command;
        if (cashCommand instanceof CashCommand.IssueCash) {
            signedTransaction = this.issueCash((CashCommand.IssueCash)this.command);
        } else if (cashCommand instanceof CashCommand.PayCash) {
            signedTransaction = this.initiatePayment((CashCommand.PayCash)this.command);
        } else if (cashCommand instanceof CashCommand.ExitCash) {
            signedTransaction = this.exitCash((CashCommand.ExitCash)this.command);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return signedTransaction;
    }

    /*
     * WARNING - void declaration
     */
    @Suspendable
    private final SignedTransaction initiatePayment(CashCommand.PayCash req) {
        void spendTX;
        void $receiver$iv;
        void keysForSigning;
        Pair pair;
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)Companion.PAYING.INSTANCE);
        TransactionBuilder builder = (TransactionBuilder)new TransactionType.General.Builder((Party)null);
        try {
            pair = this.getServiceHub().getVaultService().generateSpend(builder, StructuresKt.withoutIssuer(req.getAmount()), req.getRecipient().getOwningKey(), SetsKt.setOf((Object)((Issued)req.getAmount().getToken()).getIssuer().getParty()));
        }
        catch (InsufficientBalanceException e) {
            throw (Throwable)((Object)new CashException("Insufficent cash for spend", e));
        }
        Object object = pair;
        TransactionBuilder transactionBuilder = (TransactionBuilder)object.component1();
        List list = (List)object.component2();
        object = null;
        object = CompositeKeyKt.getKeys((Iterable)((Iterable)keysForSigning));
        for (Object element$iv : $receiver$iv) {
            PrivateKey key;
            PublicKey it = (PublicKey)element$iv;
            if ((PrivateKey)this.getServiceHub().getKeyManagementService().getKeys().get(it) == null) {
                throw (Throwable)new IllegalStateException("Could not find signing key for " + CryptoUtilities.toStringShort((PublicKey)it));
            }
            builder.signWith(new KeyPair(it, key));
        }
        SignedTransaction tx = spendTX.toSignedTransaction(false);
        this.finaliseTx(SetsKt.setOf((Object)req.getRecipient()), tx, "Unable to notarise spend");
        return tx;
    }

    /*
     * WARNING - void declaration
     */
    @Suspendable
    private final SignedTransaction exitCash(CashCommand.ExitCash req) {
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable destination$iv$iv2;
        Map $receiver$iv$iv2;
        void $receiver$iv2;
        Object it;
        Object element$iv$iv2;
        Iterable destination$iv$iv$iv;
        Object object;
        TransactionBuilder transactionBuilder;
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)Companion.EXITING.INSTANCE);
        TransactionBuilder builder = (TransactionBuilder)new TransactionType.General.Builder((Party)null);
        PartyAndReference issuer = this.getServiceHub().getMyInfo().getLegalIdentity().ref(req.getIssueRef());
        try {
            void destination$iv$iv3;
            void $receiver$iv3;
            Collection $receiver$iv$iv$iv;
            void $receiver$iv$iv3;
            Iterable this_$iv;
            Vault vault = this.getServiceHub().getVaultService().getCurrentVault();
            Amount amount = ContractsDSL.issuedBy(req.getAmount(), (PartyAndReference)issuer);
            transactionBuilder = builder;
            object = new Cash();
            Iterable iterable = this_$iv.getStates();
            void var6_10 = $receiver$iv$iv3;
            Collection collection = new ArrayList();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                StateAndRef it$iv = (StateAndRef)element$iv$iv$iv;
                if (!(it$iv.getState().getData() instanceof Cash.State)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            List list = (List)destination$iv$iv$iv;
            this_$iv = list;
            $receiver$iv$iv3 = $receiver$iv3;
            $receiver$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv3) {
                it = (StateAndRef)element$iv$iv2;
                if (!Intrinsics.areEqual((Object)((Cash.State)it.getState().getData()).getOwner(), (Object)issuer.getParty().getOwningKey())) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            list = (List)destination$iv$iv3;
            ((OnLedgerAsset)object).generateExit(transactionBuilder, amount, list);
        }
        catch (InsufficientBalanceException e) {
            throw (Throwable)((Object)new CashException("Exiting more cash than exists", e));
        }
        KeyPair myKey = this.getServiceHub().getLegalIdentityKey();
        builder.signWith(myKey);
        Map inputStatesNullable = this.getServiceHub().getVaultService().statesForRefs(builder.inputStates());
        destination$iv$iv$iv = CollectionsKt.filterNotNull((Iterable)inputStatesNullable.values());
        element$iv$iv2 = $receiver$iv2;
        it = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Object $i$a$1$filter = $receiver$iv$iv2.iterator();
        while ($i$a$1$filter.hasNext()) {
            Iterator it2;
            Object item$iv$iv = $i$a$1$filter.next();
            TransactionState $i$f$filter = (TransactionState)item$iv$iv;
            object = destination$iv$iv2;
            transactionBuilder = it2.getData();
            object.add(transactionBuilder);
        }
        List inputStates = (List)destination$iv$iv2;
        if (inputStatesNullable.size() != inputStates.size()) {
            Map.Entry it3;
            $receiver$iv$iv2 = inputStatesNullable;
            destination$iv$iv2 = $receiver$iv;
            $i$a$1$filter = new LinkedHashMap();
            Iterator iterator = $receiver$iv$iv;
            for (Map.Entry element$iv$iv3 : iterator.entrySet()) {
                it3 = element$iv$iv3;
                if (!(it3.getValue() == null)) continue;
                destination$iv$iv.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
            }
            $receiver$iv = destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList($receiver$iv.size());
            iterator = $receiver$iv$iv;
            for (Map.Entry item$iv$iv : iterator.entrySet()) {
                it3 = item$iv$iv;
                object = destination$iv$iv;
                transactionBuilder = (StateRef)it3.getKey();
                object.add(transactionBuilder);
            }
            List unresolvedStateRefs = (List)destination$iv$iv;
            throw (Throwable)new IllegalStateException("Failed to resolve input StateRefs: " + unresolvedStateRefs);
        }
        $receiver$iv = inputStates;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv4 : $receiver$iv$iv) {
            if (!(element$iv$iv4 instanceof Cash.State)) continue;
            destination$iv$iv.add(element$iv$iv4);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it4;
            Cash.State $i$f$filterIsInstanceTo = (Cash.State)item$iv$iv;
            object = destination$iv$iv;
            transactionBuilder = this.getServiceHub().getIdentityService().partyFromKey(it4.getOwner());
            object.add(transactionBuilder);
        }
        Set participants = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        SignedTransaction tx = builder.toSignedTransaction(false);
        this.finaliseTx(participants, tx, "Unable to notarise exit");
        return tx;
    }

    @Suspendable
    private final void finaliseTx(Set<Party> participants, SignedTransaction tx, String message) {
        try {
            FlowLogic.subFlow$default((FlowLogic)this, (FlowLogic)((FlowLogic)new FinalityFlow(tx, participants)), (boolean)false, (int)2, null);
        }
        catch (NotaryException e) {
            throw (Throwable)((Object)new CashException(message, e));
        }
    }

    @Suspendable
    private final SignedTransaction issueCash(CashCommand.IssueCash req) {
        this.getProgressTracker().setCurrentStep((ProgressTracker.Step)Companion.ISSUING.INSTANCE);
        TransactionBuilder builder = (TransactionBuilder)new TransactionType.General.Builder((Party)null);
        PartyAndReference issuer = this.getServiceHub().getMyInfo().getLegalIdentity().ref(req.getIssueRef());
        new Cash().generateIssue(builder, (Amount<Issued<Currency>>)ContractsDSL.issuedBy(req.getAmount(), (PartyAndReference)issuer), req.getRecipient().getOwningKey(), req.getNotary());
        KeyPair myKey = this.getServiceHub().getLegalIdentityKey();
        builder.signWith(myKey);
        SignedTransaction tx = builder.toSignedTransaction(true);
        FlowLogic.subFlow$default((FlowLogic)this, (FlowLogic)((FlowLogic)new BroadcastTransactionFlow(tx, SetsKt.setOf((Object)req.getRecipient()))), (boolean)false, (int)2, null);
        return tx;
    }

    @NotNull
    public final CashCommand getCommand() {
        return this.command;
    }

    @NotNull
    public ProgressTracker getProgressTracker() {
        return this.progressTracker;
    }

    public CashFlow(@NotNull CashCommand command, @NotNull ProgressTracker progressTracker) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)progressTracker, (String)"progressTracker");
        this.command = command;
        this.progressTracker = progressTracker;
    }

    public CashFlow(@NotNull CashCommand command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        this(command, Companion.tracker());
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u0005\u0006\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lnet/corda/flows/CashFlow$Companion;", "", "()V", "tracker", "Lnet/corda/core/utilities/ProgressTracker;", "EXITING", "ISSUING", "PAYING", "finance_main"})
    public static final class Companion {
        @NotNull
        public final ProgressTracker tracker() {
            return new ProgressTracker(new ProgressTracker.Step[]{ISSUING.INSTANCE, PAYING.INSTANCE, EXITING.INSTANCE});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/CashFlow$Companion$ISSUING;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
        public static final class ISSUING
        extends ProgressTracker.Step {
            public static final ISSUING INSTANCE;

            private ISSUING() {
                super("Issuing cash");
                INSTANCE = this;
            }

            static {
                new ISSUING();
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/CashFlow$Companion$PAYING;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
        public static final class PAYING
        extends ProgressTracker.Step {
            public static final PAYING INSTANCE;

            private PAYING() {
                super("Paying cash");
                INSTANCE = this;
            }

            static {
                new PAYING();
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/CashFlow$Companion$EXITING;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
        public static final class EXITING
        extends ProgressTracker.Step {
            public static final EXITING INSTANCE;

            private EXITING() {
                super("Exiting cash");
                INSTANCE = this;
            }

            static {
                new EXITING();
            }
        }
    }
}

